/*
 * Decompiled with CFR 0.152.
 */
package org.amic.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SwingUtil {
    private SwingUtil() {
    }

    public static boolean iterateComponents(Component comp, ComponentAction action) {
        boolean done = action.performAction(comp);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int i = 0;
            while (i < cont.getComponentCount()) {
                done = SwingUtil.iterateComponents(cont.getComponent(i), action);
                ++i;
            }
        }
        return done;
    }

    public static Rectangle screenCenter(int width, int height) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        return new Rectangle((int)((screen.getWidth() - (double)width) / 2.0), (int)((screen.getHeight() - (double)height) / 2.0), width, height);
    }

    public static DefaultMutableTreeNode getTreeNodeSelected(JTree tree) {
        TreePath tp = tree.getSelectionPath();
        if (tp != null) {
            return (DefaultMutableTreeNode)tp.getLastPathComponent();
        }
        return null;
    }

    public static Object getTreeObjectSelected(JTree tree) {
        DefaultMutableTreeNode dn = SwingUtil.getTreeNodeSelected(tree);
        if (dn != null) {
            return dn.getUserObject();
        }
        return null;
    }

    public static void expandTreeNodes(JTree tree, int level) {
        SwingUtil.expandTreeNodes(tree, (TreeNode)tree.getModel().getRoot(), level);
    }

    public static void expandTreeNodes(JTree tree, TreeNode root, int level) {
        SwingUtil.expandNode(tree, root, new TreePath(root), level);
    }

    private static void expandNode(JTree tree, TreeNode node, TreePath path, int level) {
        if (level == 0) {
            return;
        }
        tree.expandPath(path);
        int i = node.getChildCount();
        int j = 0;
        while (j < i) {
            TreeNode child = node.getChildAt(j);
            SwingUtil.expandNode(tree, child, path.pathByAddingChild(child), level - 1);
            ++j;
        }
    }

    public static interface ComponentAction {
        public boolean performAction(Component var1);
    }
}

