/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.mail;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SendMail {
    private String from;
    private String to;
    private String cc;
    private String subject;
    private String message;
    private String mailer;
    private String mailhost;
    private String user;
    private String password;
    private Date date;

    public SendMail(String from, String to, String subject, String message, String mailhost, String user, String password) {
        this(from, to, null, subject, message, "Amic-Mailer", mailhost, user, password, new Date());
    }

    public SendMail(String from, String to, String cc, String subject, String message, String mailer, String mailhost, String user, String password, Date date) {
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.subject = subject;
        this.message = message;
        this.mailer = mailer;
        this.mailhost = mailhost;
        this.user = user;
        this.password = password;
        this.date = date;
    }

    public void send() throws MessagingException {
        Properties props = System.getProperties();
        if (this.mailhost != null) {
            props.put("mail.smtp.host", this.mailhost);
        }
        if (this.user != null) {
            props.put("mail.smtp.auth", "true");
        } else {
            props.put("mail.smtp.auth", "false");
        }
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        if (this.from != null) {
            msg.setFrom((Address)new InternetAddress(this.from));
        } else {
            msg.setFrom();
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
        if (this.cc != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.cc, (boolean)false));
        }
        msg.setSubject(this.subject);
        msg.setText(this.message);
        msg.setHeader("X-Mailer", this.mailer);
        msg.setSentDate(this.date);
        if (this.user != null) {
            msg.saveChanges();
            Transport transport = session.getTransport("smtp");
            transport.connect(this.mailhost, this.user, this.password);
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            transport.close();
        } else {
            Transport.send((Message)msg);
        }
    }
}

