/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.string;

import java.awt.List;
import org.amic.util.string.FindReplace;

public class ElementsFormatter {
    public static final int TEXT = 0;
    public static final int XML = 1;
    private int type;
    private int indent;
    private boolean sameLine;
    private List elements;

    public ElementsFormatter(int type) {
        this.type = type;
        this.elements = new List();
        this.indent = this.elements.getItemCount();
    }

    public String startElement(String name) {
        this.sameLine = false;
        name = this.validateName(name);
        this.elements.add(name);
        this.indent = this.elements.getItemCount();
        switch (this.type) {
            case 0: {
                return this.getPastIndentation() + name + this.nextLine();
            }
            case 1: {
                return this.getPastIndentation() + "<" + name + ">" + this.nextLine();
            }
        }
        return "";
    }

    public String startAndEndElement(String name, String value) {
        name = this.validateName(name);
        switch (this.type) {
            case 0: {
                return this.getIndentation() + value;
            }
            case 1: {
                return this.getIndentation() + "<" + name + ">" + value + "</" + name + ">" + this.nextLine();
            }
        }
        return "";
    }

    public String startAndEndElement(String name, boolean value) {
        if (value) {
            name = this.validateName(name);
            switch (this.type) {
                case 0: {
                    this.sameLine = true;
                    return this.getIndentation() + name;
                }
                case 1: {
                    this.sameLine = false;
                    return this.getIndentation() + "<" + name + " />" + this.nextLine();
                }
            }
        }
        return "";
    }

    public String endElement() {
        if (this.indent > 0) {
            switch (this.type) {
                case 0: {
                    this.elements.remove(this.indent - 1);
                    this.indent = this.elements.getItemCount();
                    return this.nextLine();
                }
                case 1: {
                    String name = this.elements.getItem(this.indent - 1);
                    this.elements.remove(this.indent - 1);
                    this.indent = this.elements.getItemCount();
                    return this.getIndentation() + "</" + name + ">" + this.nextLine();
                }
            }
        }
        return "";
    }

    public String endList() {
        return this.nextLine();
    }

    public String addText(String text) {
        this.sameLine = false;
        switch (this.type) {
            case 0: {
                return this.getIndentation() + text;
            }
            case 1: {
                return this.getIndentation() + text;
            }
        }
        return "";
    }

    private String nextLine() {
        this.sameLine = false;
        return "\n";
    }

    private String validateName(String name) {
        if (name != null && name.length() > 0) {
            FindReplace fr = new FindReplace(name);
            fr.replaceAll("[:punct:]|[:blank:]|[:cntrl:]", "-");
            return fr.toString();
        }
        return name;
    }

    private String getIndentation() {
        if (this.sameLine) {
            return "\t";
        }
        String result = "";
        int i = 0;
        while (i < this.indent) {
            result = result + "\t";
            ++i;
        }
        this.sameLine = true;
        return result;
    }

    private String getPastIndentation() {
        if (this.sameLine) {
            return "";
        }
        String result = "";
        int i = 0;
        while (i < this.indent - 1) {
            result = result + "\t";
            ++i;
        }
        this.sameLine = true;
        return result;
    }
}

