/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.url;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class UrlCompose {
    private UrlCompose() {
    }

    public static String subsFile(URL url, String file) {
        try {
            URL temp = new URL(url.getProtocol(), url.getHost(), url.getPort(), UrlCompose.encodeQuery(file));
            return temp.toString();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static String encode(String value) {
        return UrlCompose.encodeUTF8(value);
    }

    public static String encodeQuery(String value) {
        int pos = value.indexOf("?");
        if (pos == -1 || pos == value.length() - 1) {
            return value;
        }
        return value.substring(0, pos + 1) + UrlCompose.encodeQueries(value.substring(pos + 1));
    }

    public static String encodeQueries(String value) {
        String result = "";
        StringTokenizer tok = new StringTokenizer(value, "&");
        while (tok.hasMoreElements()) {
            if (result.length() > 0) {
                result = result + "&";
            }
            String temp = tok.nextToken();
            int pos = temp.indexOf("=");
            result = result + temp.substring(0, pos + 1) + UrlCompose.encodeUTF8(temp.substring(pos + 1));
        }
        return result;
    }

    private static String encodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }
}

