/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.util.Vector;
import org.amic.properties.PropertiesTableModel;
import org.amic.util.string.ClassFormatter;
import org.amic.xml.NodeSet;
import org.amic.xml.XmlMapper;
import org.amic.xml.XmlReader;
import org.w3c.dom.NamedNodeMap;

public class XmlPropertiesModel
extends PropertiesTableModel {
    private Vector modelNode = new Vector();

    public XmlPropertiesModel(XmlReader node) {
        if (node != null) {
            this.createModel(node);
        }
    }

    private void createModel(XmlReader node) {
        XmlMapper xm = node.getMapper();
        String name = node.getName();
        String nameEx = name + ".value";
        boolean showChildren = xm.getShowChildren(nameEx);
        if (xm.getVisible(nameEx)) {
            this.modelNode.addElement(node);
            this.addRow(nameEx, null);
            this.setLabel(nameEx, xm.getLabel(nameEx));
            this.setJClass(nameEx, xm.getJClass(nameEx));
            this.setFormat(nameEx, xm.getFormat(nameEx));
            if (xm.getValids(nameEx) != null) {
                int v = 0;
                while (v < xm.getValids(nameEx).size()) {
                    this.addValidValue(nameEx, xm.getValids(nameEx).elementAt(v));
                    ++v;
                }
            }
            this.setEditable(nameEx, xm.getEditable(nameEx));
            this.setValue(nameEx, node.getValue());
        }
        NamedNodeMap nnm = node.getAttributes();
        int i = 0;
        while (i < nnm.getLength()) {
            String nameAttr = nnm.item(i).getNodeName();
            nameEx = name + "." + nameAttr;
            if (xm.getVisible(nameEx)) {
                this.modelNode.addElement(node);
                this.addRow(nameEx, null);
                this.setLabel(nameEx, xm.getLabel(nameEx));
                this.setJClass(nameEx, xm.getJClass(nameEx));
                this.setFormat(nameEx, xm.getFormat(nameEx));
                if (xm.getValids(nameEx) != null) {
                    int v = 0;
                    while (v < xm.getValids(nameEx).size()) {
                        this.addValidValue(nameEx, xm.getValids(nameEx).elementAt(v));
                        ++v;
                    }
                }
                this.setEditable(nameEx, xm.getEditable(nameEx));
                this.setValue(nameEx, node.getAttribute(nameAttr));
            }
            ++i;
        }
        if (showChildren) {
            NodeSet nodes = node.getNodeSet();
            while (nodes.hasNextNode()) {
                this.createModel(nodes.nextNode());
            }
        }
    }

    public Object getValueAt(int row, int col) {
        Object result = super.getValueAt(row, col);
        if (row >= 0 && row < this.getRowCount() && col == 1) {
            XmlReader xr = (XmlReader)this.modelNode.get(row);
            PropertiesTableModel.Property prop = this.getRowByIndex(row);
            if (prop != null) {
                int p = prop.name.indexOf(46);
                String part = prop.name.substring(p + 1);
                result = part.equals("value") ? xr.getValue() : xr.getAttribute(part);
            }
        }
        return result;
    }

    public void setValueAt(Object value, int row, int col) {
        super.setValueAt(value, row, col);
        if (row >= 0 && row < this.getRowCount() && col == 1) {
            String text;
            XmlReader xr = (XmlReader)this.modelNode.get(row);
            String format = null;
            PropertiesTableModel.Property prop = this.getRowByIndex(row);
            if (prop != null) {
                format = prop.format;
            }
            int p = prop.name.indexOf(46);
            String part = prop.name.substring(p + 1);
            String string = text = format == null ? ClassFormatter.format(value) : ClassFormatter.format(value, format);
            if (part.equals("value")) {
                xr.getWriter().setText(text);
            } else {
                xr.getWriter().setAttribute(part, text);
            }
        }
    }

    public void clearModel() {
        super.clearModel();
        this.modelNode = new Vector();
    }
}

