/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.util.Hashtable;
import java.util.Iterator;
import org.amic.xml.NodeSet;
import org.amic.xml.XmlFinder;
import org.amic.xml.XmlMapper;
import org.amic.xml.XmlReader;

public class XmlQuickFinder {
    private XmlReader root;
    private Hashtable table = null;

    public XmlQuickFinder() {
        this(null);
    }

    public XmlQuickFinder(XmlReader reader) {
        this.root = reader;
    }

    public void optimizeFor(String expression, String keyExpression) {
        this.optimizeFor(this.root, expression, keyExpression);
    }

    public void optimizeFor(XmlReader node, String expression, String keyExpression) {
        NodeSet ns = new XmlFinder(node).findNodes(expression);
        if (ns != null && ns.size() > 0) {
            if (this.table == null) {
                this.table = new Hashtable(ns.size());
            }
            while (ns.hasNextNode()) {
                XmlReader tmp = ns.nextNode();
                this.table.put(XmlMapper.formatNode(keyExpression, tmp, null), tmp);
            }
        }
    }

    public XmlReader getNode(String key) {
        if (this.table == null || key == null) {
            return null;
        }
        return (XmlReader)this.table.get(key);
    }

    public Iterator getKeys() {
        return this.table.keySet().iterator();
    }

    public NodeSet getResults() {
        NodeSet ns = new NodeSet();
        Iterator it = this.getKeys();
        while (it.hasNext()) {
            ns.addNode(this.getNode((String)it.next()));
        }
        return ns;
    }
}

