/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.swing.impl.panel.dimension;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import org.gvsig.raster.wmts.ogc.struct.WMTSDimension;
import org.gvsig.raster.wmts.swing.impl.panel.dimension.DimensionComboPanel;
import org.gvsig.raster.wmts.swing.impl.panel.dimension.SelectedValuePanel;
import org.gvsig.raster.wmts.swing.impl.panel.dimension.ValuesDimensionListPanel;

public class DimensionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DimensionComboPanel dimensionPanel = null;
    private ValuesDimensionListPanel valuesDimensionListPanel = null;
    private SelectedValuePanel selectedValuePanel = null;
    private List<WMTSDimension> dataModel = null;

    public DimensionPanel() {
        this.init();
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 10;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getDimensionPanel(), gridBagConstraints1);
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.anchor = 10;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.getValuesDimensionListPanel(), gridBagConstraints1);
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.weighty = 0.0;
        this.add((Component)this.getSelectedValuePanel(), gridBagConstraints1);
    }

    public void setDimensions(List<WMTSDimension> dimensions) {
        this.dataModel = dimensions;
        this.getDimensionPanel().clearDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            WMTSDimension dim = dimensions.get(i);
            this.getDimensionPanel().getDimensionList().addItem(dim.getIdentifier());
        }
        this.fillDefaultValuesOfSelectedDimension();
    }

    private void fillDefaultValuesOfSelectedDimension() {
        String selectedDimension = this.getDimensionPanel().getSelectedDimension();
        this.getValuesDimensionListPanel().clearList();
        this.getSelectedValuePanel().getSelectedValue().setText("");
        for (int i = 0; i < this.dataModel.size(); ++i) {
            WMTSDimension dim = this.dataModel.get(i);
            if (dim.getIdentifier().equals(selectedDimension)) {
                for (int j = 0; j < dim.getValueList().size(); ++j) {
                    this.getValuesDimensionListPanel().addElement((String)dim.getValueList().get(j));
                }
            }
            this.getSelectedValuePanel().setValue(dim.getDefaultValue());
        }
    }

    public void clearGraphicComponents() {
        this.getDimensionPanel().getDimensionList().removeAllItems();
        this.getValuesDimensionListPanel().clearList();
        this.getSelectedValuePanel().getSelectedValue().setText("");
    }

    public DimensionComboPanel getDimensionPanel() {
        if (this.dimensionPanel == null) {
            this.dimensionPanel = new DimensionComboPanel();
        }
        return this.dimensionPanel;
    }

    public ValuesDimensionListPanel getValuesDimensionListPanel() {
        if (this.valuesDimensionListPanel == null) {
            this.valuesDimensionListPanel = new ValuesDimensionListPanel();
        }
        return this.valuesDimensionListPanel;
    }

    public SelectedValuePanel getSelectedValuePanel() {
        if (this.selectedValuePanel == null) {
            this.selectedValuePanel = new SelectedValuePanel();
        }
        return this.selectedValuePanel;
    }
}

