/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.reproject.algorithm;

import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.reproject.algorithm.Reproject;
import org.gvsig.raster.reproject.algorithm.ReprojectException;

public class ReprojectProcess
extends DataProcess {
    public static String[] INTERP_METHODS = new String[]{"Nearest", "Bilinear", "InverseDistance"};
    public static String RASTER_STORE = "RasterStore";
    public static String PATH = "Path";
    public static String DST_PROJECTION = "DST_Projection";
    public static String SRC_PROJECTION = "SRC_Projection";
    public static String SIZEX = "SizeX";
    public static String SIZEY = "SizeY";
    public static String CELLSIZE = "CellSize";
    public static String FILENAME = "FileName";
    public static String INTERPOLATION = "Interpolation";
    private RasterDataStore store = null;
    private String filename = null;
    private IProjection projdst = null;
    private IProjection projsrc = null;
    private Reproject reproject = null;
    private int w = 0;
    private int h = 0;
    private double cellSize = 0.0;
    private int interpolation = 0;

    public static void registerParameters() {
        ReprojectProcess.registerInputParameter((String)RASTER_STORE, RasterDataStore.class, (String)"RasterReprojectionProcess");
        ReprojectProcess.registerInputParameter((String)PATH, String.class, (String)"RasterReprojectionProcess");
        ReprojectProcess.registerInputParameter((String)DST_PROJECTION, IProjection.class, (String)"RasterReprojectionProcess");
        ReprojectProcess.registerInputParameter((String)SRC_PROJECTION, IProjection.class, (String)"RasterReprojectionProcess");
        ReprojectProcess.registerInputParameter((String)SIZEX, Integer.class, (String)"RasterReprojectionProcess");
        ReprojectProcess.registerInputParameter((String)SIZEY, Integer.class, (String)"RasterReprojectionProcess");
        ReprojectProcess.registerInputParameter((String)CELLSIZE, Double.class, (String)"RasterReprojectionProcess");
        ReprojectProcess.registerInputParameter((String)INTERPOLATION, Integer.class, (String)"RasterReprojectionProcess");
        ReprojectProcess.registerOutputParameter((String)FILENAME, String.class, (String)"RasterReprojectionProcess");
    }

    public void init() {
        this.store = this.getParam(RASTER_STORE) != null ? (RasterDataStore)this.getParam(RASTER_STORE) : null;
        this.filename = this.getStringParam(PATH);
        this.projdst = this.getParam(DST_PROJECTION) != null ? (IProjection)this.getParam(DST_PROJECTION) : null;
        this.projsrc = this.getParam(SRC_PROJECTION) != null ? (IProjection)this.getParam(SRC_PROJECTION) : null;
        this.w = this.getIntParam(SIZEX);
        this.h = this.getIntParam(SIZEY);
        this.cellSize = this.getDoubleParam(CELLSIZE);
        this.interpolation = this.getIntParam(INTERPOLATION);
    }

    public void process() throws ProcessInterruptedException {
        this.insertLineLog(Messages.getText((String)"reprojecting"));
        this.store = this.store.newNotTiledDataStore();
        this.reproject = new Reproject(this.store, this.filename, this.interpolation, this);
        try {
            int result = this.reproject.warp(this.projdst, this.projsrc, this.w, this.h, this.cellSize);
            if (result != 0) {
                if (this.incrementableTask != null) {
                    this.incrementableTask.processFinalize();
                    this.setProgressActive(false);
                }
                this.messageBoxError("transformation_not_possible", (Object)this);
                return;
            }
            this.addOutputValue(FILENAME, this.filename);
        }
        catch (ReprojectException e) {
            if (this.incrementableTask != null) {
                this.incrementableTask.processFinalize();
            }
            this.messageBoxError("error_reprojecting", (Object)this, e);
        }
    }

    public String getTitle() {
        return Messages.getText((String)"reprojecting");
    }
}

