/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jzkit.a2j.codec.runtime.AsnBitString;
import org.jzkit.a2j.codec.runtime.BERInputStream;
import org.jzkit.a2j.codec.runtime.BEROutputStream;
import org.jzkit.a2j.codec.runtime.SerializationManager;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.gen.AsnUseful.EXTERNAL_type;
import org.jzkit.a2j.gen.AsnUseful.encoding_inline0_type;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.util.FormatSpecOIDHelper;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.CharSetandLanguageNegotiation_type;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.Iso10646_type;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.OriginProposal_type;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.proposedCharSets_inline0_choice1_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.AccessControlRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Close_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DeleteResultSetResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ElementSetNames_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ExtendedServicesResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.IdAuthentication_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.InitializeRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.InitializeResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.OtherInformationItem43_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PDU_codec;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PDU_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Query_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ResourceControlResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ResourceReportResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ScanResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SortRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SortResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.idPass_inline0_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.information_inline44_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.recordComposition_inline9_type;
import org.jzkit.z3950.util.APDUEvent;
import org.jzkit.z3950.util.APDUObservable;

public class ZEndpoint
extends Thread {
    private Socket z_assoc = null;
    private InputStream incoming_data = null;
    private OutputStream outgoing_data = null;
    private PDU_codec codec = PDU_codec.getCodec();
    private OIDRegister reg = null;
    private boolean running = true;
    private boolean close_notified = false;
    private String target_hostname;
    private int target_port;
    private String charset_encoding = "US-ASCII";
    private int auth_type;
    private int pref_message_size = 0x100000;
    private int exceptional_record_size = 0x100000;
    private String service_user_principal;
    private String service_user_group;
    private String service_user_credentials;
    private boolean use_refid = true;
    private int refid_counter = 0;
    private int assoc_status = 0;
    public APDUObservable pdu_announcer = new APDUObservable();
    private boolean supports_concurrent_operations = true;
    private Object op_counter_lock = new Object();
    private int op_counter;
    private Vector outbound_apdu_queue = new Vector();
    private static final int ASSOC_STATUS_IDLE = 0;
    private static final int ASSOC_STATUS_CONNECTING = 1;
    private static final int ASSOC_STATUS_CONNECTED = 2;
    private static final int ASSOC_STATUS_PERM_FAILURE = 3;
    private static final String EMPTY_STRING = "";
    public static final String US_ASCII_ENCODING = "US-ASCII";
    public static final String UTF_8_ENCODING = "UTF-8";
    public static final String UTF_16_ENCODING = "UTF-16";
    private Logger log = Logger.getLogger((class$org$jzkit$z3950$util$ZEndpoint == null ? (class$org$jzkit$z3950$util$ZEndpoint = ZEndpoint.class$("org.jzkit.z3950.util.ZEndpoint")) : class$org$jzkit$z3950$util$ZEndpoint).getName());
    private static int dbg_counter = 0;
    private static int active_thread_counter = 0;
    private static final int DEFAULT_BUFF_SIZE = 32768;
    private boolean do_charset_neg = false;
    static /* synthetic */ Class class$org$jzkit$z3950$util$ZEndpoint;

    public ZEndpoint(OIDRegister reg) {
        super("Z3950 Search Thread");
        this.reg = reg;
        ++dbg_counter;
    }

    protected void finalize() {
        this.log.fine("ZEndpoint::finalize() (" + --dbg_counter + " active)");
    }

    protected void notifyAPDUEvent(PDU_type pdu) {
        this.log.fine("notifyAPDUEvent : " + pdu.which);
        byte[] refid = null;
        switch (pdu.which) {
            case 1: {
                refid = ((InitializeResponse_type)pdu.o).referenceId;
                break;
            }
            case 3: {
                refid = ((SearchResponse_type)pdu.o).referenceId;
                break;
            }
            case 5: {
                refid = ((PresentResponse_type)pdu.o).referenceId;
                break;
            }
            case 7: {
                refid = ((DeleteResultSetResponse_type)pdu.o).referenceId;
                break;
            }
            case 8: {
                refid = ((AccessControlRequest_type)pdu.o).referenceId;
                break;
            }
            case 11: {
                refid = ((ResourceControlResponse_type)pdu.o).referenceId;
                break;
            }
            case 14: {
                refid = ((ResourceReportResponse_type)pdu.o).referenceId;
                break;
            }
            case 16: {
                refid = ((ScanResponse_type)pdu.o).referenceId;
                break;
            }
            case 18: {
                refid = ((SortResponse_type)pdu.o).referenceId;
                break;
            }
            case 21: {
                refid = ((ExtendedServicesResponse_type)pdu.o).referenceId;
                break;
            }
            case 22: {
                refid = ((Close_type)pdu.o).referenceId;
            }
        }
        this.log.fine("Incoming PDU refid: " + (refid != null ? new String(refid) : null));
        APDUEvent e = new APDUEvent(this, pdu, refid != null ? new String(refid) : null);
        this.pdu_announcer.setChanged();
        this.pdu_announcer.notifyObservers(e);
    }

    private void sendInitRequest(AsnBitString versionInfo, AsnBitString ops, String refId, int auth_type, String principal, String group, String credentials) throws IOException {
        PDU_type pdu = new PDU_type();
        InitializeRequest_type initialize_request = new InitializeRequest_type();
        pdu.o = initialize_request;
        pdu.which = 0;
        if (refId != null) {
            initialize_request.referenceId = refId.getBytes();
        }
        initialize_request.protocolVersion = versionInfo;
        initialize_request.options = ops;
        initialize_request.preferredMessageSize = BigInteger.valueOf(this.pref_message_size);
        initialize_request.exceptionalRecordSize = BigInteger.valueOf(this.exceptional_record_size);
        switch (auth_type) {
            case 1: {
                this.log.fine("Using anonymous authentication");
                initialize_request.idAuthentication = new IdAuthentication_type();
                initialize_request.idAuthentication.which = 2;
                break;
            }
            case 2: {
                this.log.fine("Using idopen authentication : \"" + principal + "\"");
                initialize_request.idAuthentication = new IdAuthentication_type();
                initialize_request.idAuthentication.which = 0;
                initialize_request.idAuthentication.o = principal;
                break;
            }
            case 3: {
                this.log.fine("Using idpass authentication : user:\"" + principal + "\"" + ", group:\"" + group + "\"" + ", pass:\"" + credentials + "\"");
                initialize_request.idAuthentication = new IdAuthentication_type();
                initialize_request.idAuthentication.which = 1;
                idPass_inline0_type idpass = new idPass_inline0_type();
                idpass.groupId = group;
                idpass.userId = principal;
                idpass.password = credentials;
                initialize_request.idAuthentication.o = idpass;
                break;
            }
            default: {
                this.log.fine("Not using z-authentication");
                initialize_request.idAuthentication = null;
            }
        }
        initialize_request.implementationId = "174";
        initialize_request.implementationName = "JZKit2 Generic ZEndpoint";
        initialize_request.implementationVersion = "2.0";
        initialize_request.userInformationField = null;
        if (this.do_charset_neg) {
            if (initialize_request.otherInfo == null) {
                initialize_request.otherInfo = new ArrayList();
            }
            initialize_request.otherInfo.add(this.createCharsetNeg());
        }
        this.encodeAndSend(pdu);
    }

    private OtherInformationItem43_type createCharsetNeg() {
        OtherInformationItem43_type oit = new OtherInformationItem43_type();
        oit.information = new information_inline44_type();
        oit.information.which = 2;
        EXTERNAL_type et = new EXTERNAL_type();
        oit.information.o = et;
        et.direct_reference = this.reg.oidByName("z_charset_neg_3");
        if (et.direct_reference == null) {
            this.log.log(Level.SEVERE, "Unable to locate direct reference for oid");
        }
        et.encoding = new encoding_inline0_type();
        et.encoding.which = 0;
        CharSetandLanguageNegotiation_type t = new CharSetandLanguageNegotiation_type();
        et.encoding.o = t;
        t.which = 0;
        OriginProposal_type proposal = new OriginProposal_type();
        t.o = proposal;
        proposal.proposedCharSets = new ArrayList();
        proposedCharSets_inline0_choice1_type c1 = new proposedCharSets_inline0_choice1_type();
        c1.which = 1;
        Iso10646_type utf_8_request = new Iso10646_type();
        c1.o = utf_8_request;
        utf_8_request.encodingLevel = this.reg.oidByName("charset_utf8");
        proposal.proposedCharSets.add(c1);
        return oit;
    }

    public void sendSearchRequest(ArrayList database_names, Query_type z3950_query_model, String reference_id, int ssub, int lslb, int mspn, boolean replace, String setname, String ssen, String msen, int[] prefRecSynOID) throws IOException {
        PDU_type pdu = new PDU_type();
        pdu.which = 2;
        SearchRequest_type srt = new SearchRequest_type();
        pdu.o = srt;
        if (reference_id != null) {
            srt.referenceId = reference_id.getBytes();
        }
        srt.smallSetUpperBound = BigInteger.valueOf(ssub);
        srt.largeSetLowerBound = BigInteger.valueOf(lslb);
        srt.mediumSetPresentNumber = BigInteger.valueOf(mspn);
        srt.replaceIndicator = Boolean.TRUE;
        srt.resultSetName = setname;
        srt.databaseNames = database_names;
        if (ssen != null) {
            srt.smallSetElementSetNames = new ElementSetNames_type();
            srt.smallSetElementSetNames.which = 0;
            srt.smallSetElementSetNames.o = ssen;
        }
        if (msen != null) {
            srt.mediumSetElementSetNames = new ElementSetNames_type();
            srt.mediumSetElementSetNames.which = 0;
            srt.mediumSetElementSetNames.o = msen;
        }
        srt.preferredRecordSyntax = prefRecSynOID;
        srt.query = z3950_query_model;
        this.encodeAndSend(pdu);
    }

    public void sendPresentRequest(String refid, String rsname, long first, long count, ExplicitRecordFormatSpecification spec) throws IOException {
        this.sendPresentRequest(refid, rsname, first, count, spec.getSetname().getRef(), FormatSpecOIDHelper.getOID((OIDRegister)this.reg, (ExplicitRecordFormatSpecification)spec));
    }

    public void sendPresentRequest(String refid, String rsname, long first, long count, String element_set_name, int[] preferred_record_syntax_oid) throws IOException {
        this.log.fine("sendPresentRequest, refid=" + refid);
        this.log.fine("setname: " + rsname);
        this.log.fine("first=" + first);
        this.log.fine("count=" + count);
        PDU_type pdu = new PDU_type();
        pdu.which = 4;
        PresentRequest_type pr = new PresentRequest_type();
        pdu.o = pr;
        if (refid != null) {
            pr.referenceId = refid.getBytes();
        }
        pr.resultSetId = rsname;
        pr.resultSetStartPoint = BigInteger.valueOf(first);
        pr.numberOfRecordsRequested = BigInteger.valueOf(count);
        if (element_set_name != null) {
            pr.recordComposition = new recordComposition_inline9_type();
            pr.recordComposition.which = 0;
            ElementSetNames_type esn = new ElementSetNames_type();
            pr.recordComposition.o = esn;
            esn.which = 0;
            esn.o = element_set_name;
        }
        pr.preferredRecordSyntax = preferred_record_syntax_oid;
        this.encodeAndSend(pdu);
    }

    public void sendSortRequest(String refid, ArrayList input_result_set_names, String output_result_set_name, ArrayList sort_sequence) throws IOException {
        PDU_type pdu = new PDU_type();
        pdu.which = 17;
        SortRequest_type sr = new SortRequest_type();
        pdu.o = sr;
        if (refid != null) {
            sr.referenceId = refid.getBytes();
        }
        sr.inputResultSetNames = input_result_set_names;
        sr.sortedResultSetName = output_result_set_name;
        sr.sortSequence = sort_sequence;
        this.encodeAndSend(pdu);
    }

    public void sendScanRequest(String refid, ArrayList database_names, Query_type z3950_query_model, long step_size, long number_of_terms_requested, long preferred_position_in_response) throws IOException {
        this.log.fine("Sending scan request....");
    }

    public void sendCloseRequest(String refid, long reason, String diagnosticInfo) throws IOException {
        PDU_type pdu = new PDU_type();
        pdu.which = 22;
        Close_type cr = new Close_type();
        pdu.o = cr;
        if (refid != null) {
            cr.referenceId = refid.getBytes();
        }
        cr.closeReason = BigInteger.valueOf(reason);
        cr.diagnosticInformation = diagnosticInfo;
        this.encodeAndSend(pdu);
    }

    public void setSerialOps() {
        this.supports_concurrent_operations = false;
    }

    public void encodeAndSend(PDU_type the_pdu) throws IOException {
        this.log.fine("encodeAndSend...");
        if (!this.supports_concurrent_operations && the_pdu.which != 22) {
            this.enqueueOutboundAPDU(the_pdu);
            this.sendPending();
        } else {
            this.internalEncodeAndSend(the_pdu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueOutboundAPDU(PDU_type the_pdu) {
        this.log.fine("enqueue outbound apdu");
        Vector vector = this.outbound_apdu_queue;
        synchronized (vector) {
            this.outbound_apdu_queue.add(the_pdu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPending() {
        this.log.fine("sendPending()");
        PDU_type pdu = null;
        Object object = this.op_counter_lock;
        synchronized (object) {
            if (this.op_counter == 0) {
                Vector vector = this.outbound_apdu_queue;
                synchronized (vector) {
                    if (this.outbound_apdu_queue.size() > 0) {
                        pdu = (PDU_type)this.outbound_apdu_queue.remove(0);
                    }
                }
            }
            if (pdu != null) {
                try {
                    this.log.fine("Sending queued apdu");
                    this.internalEncodeAndSend(pdu);
                }
                catch (IOException ioe) {
                    this.log.log(Level.SEVERE, "Problem sending enqueued apdu", ioe);
                }
            }
        }
    }

    private synchronized void internalEncodeAndSend(PDU_type the_pdu) throws IOException {
        this.incOpCount();
        BEROutputStream encoder = new BEROutputStream(32768, this.charset_encoding, this.reg);
        this.codec.serialize((SerializationManager)encoder, the_pdu, false, "PDU");
        encoder.flush();
        encoder.writeTo(this.outgoing_data);
        this.outgoing_data.flush();
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incOpCount() {
        Object object = this.op_counter_lock;
        synchronized (object) {
            ++this.op_counter;
            this.op_counter_lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decOpCount() {
        Object object = this.op_counter_lock;
        synchronized (object) {
            --this.op_counter;
            this.op_counter_lock.notifyAll();
        }
    }

    public void notifyClose() {
        PDU_type pdu = new PDU_type();
        pdu.which = 22;
        Close_type close = new Close_type();
        pdu.o = close;
        close.closeReason = BigInteger.valueOf(100L);
        close.diagnosticInformation = "Internal close notification";
        this.notifyAPDUEvent(pdu);
    }

    public void shutdown() throws IOException {
        this.log.fine("ZEndpoint::shutdown() - host=" + this.target_hostname + " status=" + this.assoc_status + " running=" + this.running);
        if (this.z_assoc != null) {
            if (this.assoc_status == 2) {
                this.sendCloseRequest(null, 0L, "User requested shutdown");
            }
            this.interrupt();
            this.running = false;
            this.z_assoc.close();
            this.z_assoc = null;
            this.assoc_status = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.log.fine("Bringing assoc up........Active Z Thread counter = " + ++active_thread_counter);
        this.log.fine("My thread priority : " + this.getPriority());
        this.log.fine("My isDaemon: " + this.isDaemon());
        try {
            this.assoc_status = 1;
            this.connect();
            this.assoc_status = 2;
            this.log.fine("Connect completed OK, Listening for incoming PDUs");
        }
        catch (ConnectException ce) {
            this.log.info(ce.toString());
            this.assoc_status = 3;
            this.sendDummyFailInitResponse(ce.toString());
            this.running = false;
        }
        catch (IOException ioe) {
            this.log.log(Level.SEVERE, "ZEndpoint thread encountered an exception", ioe);
            this.assoc_status = 3;
            this.sendDummyFailInitResponse(ioe.toString());
            this.running = false;
        }
        while (this.running) {
            try {
                this.log.fine("Waiting for data on input stream.....");
                BERInputStream bds = new BERInputStream(this.incoming_data, this.charset_encoding, 32768, this.reg);
                PDU_type pdu = null;
                pdu = (PDU_type)this.codec.serialize((SerializationManager)bds, pdu, false, "PDU");
                this.log.fine("Notifiy observers");
                if (pdu.which == 22) {
                    this.log.fine("Just got a close APDU");
                    this.close_notified = true;
                }
                this.decOpCount();
                this.notifyAPDUEvent(pdu);
                if (!this.close_notified) {
                    this.sendPending();
                }
                this.log.fine("Yield to other threads....");
                Thread.yield();
            }
            catch (InterruptedIOException iioe) {
                this.log.fine("Processing java.io.InterruptedIOException, shut down association - hostname=" + this.target_hostname);
                this.log.info(iioe.toString());
                this.running = false;
            }
            catch (SocketException se) {
                this.log.log(Level.SEVERE, "problem", se);
                this.log.info("SocketException");
                this.log.info(se.toString() + " - hostname=" + this.target_hostname);
                this.running = false;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "ZEndpoint Unknown error", e);
                this.log.info(e.toString() + " - hostname=" + this.target_hostname);
                this.running = false;
            }
        }
        Object e = this.op_counter_lock;
        synchronized (e) {
            this.op_counter_lock.notifyAll();
        }
        if (!this.close_notified) {
            this.notifyClose();
        }
        this.log.fine("End of ZEndpoint listening thread for host " + this.target_hostname + " active z thread counter=" + --active_thread_counter);
        this.pdu_announcer.deleteObservers();
        this.pdu_announcer = null;
        try {
            this.incoming_data = null;
            this.outgoing_data = null;
            if (this.z_assoc != null) {
                this.z_assoc.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assoc_status = 0;
        this.z_assoc = null;
    }

    protected void connect() throws ConnectException, IOException {
        this.connect(null);
    }

    protected void connect(String refid) throws ConnectException, IOException {
        if (null == this.target_hostname || this.target_port <= 0) {
            throw new ConnectException("Properties do not contain ServiceHost and/or ServicePort");
        }
        this.log.fine("Attempting to connect to " + this.target_hostname + ":" + this.target_port);
        int timeout = 20000;
        this.z_assoc = new Socket(this.target_hostname, this.target_port);
        this.outgoing_data = this.z_assoc.getOutputStream();
        this.incoming_data = this.z_assoc.getInputStream();
        this.log.fine("Connect completed OK, send init request (nodelay=" + this.z_assoc.getTcpNoDelay() + ", timeout=" + this.z_assoc.getSoTimeout() + ", linger=" + this.z_assoc.getSoLinger() + ")");
        AsnBitString version_info = new AsnBitString();
        version_info.setBit(0);
        version_info.setBit(1);
        version_info.setBit(2);
        AsnBitString options = new AsnBitString();
        options.setBit(0);
        options.setBit(1);
        options.setBit(2);
        options.setBit(7);
        options.setBit(8);
        options.setBit(10);
        options.setBit(13);
        options.setBit(14);
        Object s = null;
        this.sendInitRequest(version_info, options, refid, this.auth_type, this.service_user_principal, this.service_user_group, this.service_user_credentials);
        this.log.fine("Sent init request");
    }

    private void sendDummyFailInitResponse(String reason) {
        PDU_type pdu = new PDU_type();
        InitializeResponse_type initialize_response = new InitializeResponse_type();
        pdu.o = initialize_response;
        pdu.which = 1;
        initialize_response.referenceId = new byte[0];
        initialize_response.protocolVersion = new AsnBitString();
        initialize_response.options = new AsnBitString();
        initialize_response.result = Boolean.FALSE;
        this.notifyAPDUEvent(pdu);
    }

    public int getAssocStatus() {
        return this.assoc_status;
    }

    public Observable getPDUAnnouncer() {
        return this.pdu_announcer;
    }

    public String genRefid(String base) {
        if (this.use_refid) {
            return base + ":" + this.refid_counter++;
        }
        return null;
    }

    public String getHost() {
        return this.target_hostname;
    }

    public void setHost(String host) {
        this.target_hostname = host;
    }

    public int getPort() {
        return this.target_port;
    }

    public void setPort(int port) {
        this.target_port = port;
    }

    public String getCharsetEncoding() {
        return this.charset_encoding;
    }

    public void setCharsetEncoding(String enc) {
        if (enc == null) {
            throw new RuntimeException("Null charset encoding is not allowed");
        }
        this.charset_encoding = enc;
    }

    public int getAuthType() {
        return this.auth_type;
    }

    public void setAuthType(int auth_type) {
        this.auth_type = auth_type;
    }

    public int getPrefMessageSize() {
        return this.pref_message_size;
    }

    public void setPrefMessageSize(int pref_message_size) {
        this.pref_message_size = pref_message_size;
    }

    public int getExceptionalMessageSize() {
        return this.exceptional_record_size;
    }

    public void setExceptionalMessageSize(int exceptional_record_size) {
        this.exceptional_record_size = exceptional_record_size;
    }

    public String getServiceUserPrincipal() {
        return this.service_user_principal;
    }

    public void setServiceUserPrincipal(String service_user_principal) {
        this.service_user_principal = service_user_principal;
    }

    public String getServiceUserGroup() {
        return this.service_user_group;
    }

    public void setServiceUserGroup(String service_user_group) {
        this.service_user_group = service_user_group;
    }

    public String getServiceUserCredentials() {
        return this.service_user_credentials;
    }

    public void setServiceUserCredentials(String service_user_credentials) {
        this.service_user_credentials = service_user_credentials;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

