/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal;

import java.io.File;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.sqlite.dal.SQLiteConnectionParameters;
import org.gvsig.sqlite.dal.SQLiteUtils;

public class SQLiteConnectionParametersHelper {
    private final JDBCConnectionParameters parameters;
    private static final String ENABLE_SHARED_CACHE = "enable_shared_cache";
    private static final String ENABLE_LOAD_EXTENSION = "enable_load_extension";
    private static final String DATABASE_FILE = "database_file";

    public SQLiteConnectionParametersHelper(JDBCConnectionParameters parameters) {
        this.parameters = parameters;
    }

    public String getUrl() {
        String url = (String)this.getDynValue("url");
        if (StringUtils.isBlank((CharSequence)url)) {
            url = SQLiteUtils.getConnectionURL((SQLiteConnectionParameters)this.parameters);
            this.setDynValue("url", url);
        }
        return url;
    }

    public void validate() throws ValidateDataParametersException {
        if (this.getDynValue("jdbcdriverclass") == null) {
            this.setDynValue("jdbcdriverclass", "org.sqlite.JDBC");
        }
        if (this.getFile() == null) {
            throw new ValidateDataParametersException();
        }
    }

    private Object getDynValue(String name) {
        return this.parameters.getDynValue(name);
    }

    private void setDynValue(String name, Object value) {
        this.parameters.setDynValue(name, value);
    }

    public boolean getEnableLoadExtension() {
        return (Boolean)this.getDynValue(ENABLE_LOAD_EXTENSION);
    }

    public boolean getEnableSharedCache() {
        return (Boolean)this.getDynValue(ENABLE_SHARED_CACHE);
    }

    public void setEnableLoadExtension(boolean v) {
        this.setDynValue(ENABLE_LOAD_EXTENSION, v);
    }

    public void setEnableSharedCache(boolean v) {
        this.setDynValue(ENABLE_SHARED_CACHE, v);
    }

    public File getFile() {
        File f = (File)this.getDynValue(DATABASE_FILE);
        if (this.getDynValue("dbname") == null && f != null) {
            String dbname = FilenameUtils.getBaseName((String)f.getName());
            this.setDynValue("dbname", dbname);
        }
        return f;
    }

    public void setFile(File database) {
        this.setDynValue(DATABASE_FILE, database);
        if (this.getDynValue("dbname") == null && database != null) {
            String dbname = FilenameUtils.getBaseName((String)database.getName());
            this.setDynValue("dbname", dbname);
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty(ENABLE_SHARED_CACHE, BooleanUtils.toStringTrueFalse((boolean)this.getEnableSharedCache()));
        props.setProperty(ENABLE_LOAD_EXTENSION, BooleanUtils.toStringTrueFalse((boolean)this.getEnableLoadExtension()));
        return props;
    }
}

