/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.sqlite.dal.SQLiteConnectionParameters;

public class SQLiteUtils {
    public static final String SQLITE_JDBC_DRIVER = "org.sqlite.JDBC";
    public static final String EXTENSION_SQLITE = "sqlite";
    public static final String EXTENSION_SQLITE3 = "sqlite3";
    public static final String EXTENSION_DB = "db";
    public static final String EXTENSION_DB3 = "db3";
    public static final String EXTENSION_S3DB = "s3db";
    public static final String EXTENSION_SL3 = "sl3";

    public static File[] getFiles(File f) {
        if (f == null) {
            return null;
        }
        String s = SQLiteUtils.removeFileNameExtension(f.getName()) + ".";
        File[] files = new File[]{new File(f.getParentFile(), s + "gpkg"), new File(f.getParentFile(), s + "gpkx"), new File(f.getParentFile(), s + EXTENSION_DB), new File(f.getParentFile(), s + EXTENSION_DB3), new File(f.getParentFile(), s + EXTENSION_SQLITE), new File(f.getParentFile(), s + EXTENSION_SQLITE3), new File(f.getParentFile(), s + EXTENSION_S3DB), new File(f.getParentFile(), s + EXTENSION_SL3), new File(f.getParentFile(), s + "gpkg-shm"), new File(f.getParentFile(), s + "gpkg-wal")};
        return files;
    }

    public static boolean existsdb(File f) {
        File[] files;
        for (File file : files = SQLiteUtils.getFiles(f)) {
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean removedb(File f) {
        try {
            File[] files;
            for (File file : files = SQLiteUtils.getFiles(f)) {
                if (!file.exists()) continue;
                FileUtils.delete((File)file);
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static File normalizeFile(File f) {
        if (f == null) {
            return null;
        }
        f = new File(f.getParentFile(), SQLiteUtils.normalizeFileName(f.getName()));
        return f;
    }

    public static String normalizeFileName(String name) {
        String s = SQLiteUtils.removeFileNameExtension(name);
        if (s == null) {
            return null;
        }
        return s + "." + "gpkg";
    }

    public static String removeFileNameExtension(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return FilenameUtils.removeExtension((String)name);
    }

    public static File getLocalFile(SQLiteConnectionParameters params) {
        File f = params.getFile();
        return SQLiteUtils.normalizeFile(f);
    }

    public static String getConnectionURL(SQLiteConnectionParameters params) {
        String fname = params.getFile().getAbsolutePath().replace("\\", "/");
        if (StringUtils.isBlank((CharSequence)FilenameUtils.getExtension((String)fname))) {
            fname = fname.endsWith(".") ? fname + "gpkg" : fname + "." + "gpkg";
            params.setFile(new File(fname));
        }
        String connectionURL = "jdbc:sqlite:" + fname;
        return connectionURL;
    }
}

