/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.SQLException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_Extent
extends Functions.AbstractAggregate {
    private Envelope env = null;
    private long count = 0L;

    public ST_Extent(SQLiteConnection conn) {
        super("ST_Extent", conn);
    }

    protected void xStep() throws SQLException {
        try {
            Geometry geom;
            ++this.count;
            byte[] bytes = this.value_blob(0);
            if (bytes == null) {
                return;
            }
            SQLiteConnection conn = this.getConnection();
            GeopackageGeometryParser parser = GeopackageUtils.createGeometryParser();
            parser.parseEnvelope(bytes);
            Envelope env_geom = parser.getEnvelope(conn);
            if (env_geom == null && (geom = parser.parseToGeometry(conn, bytes)) != null) {
                env_geom = geom.getEnvelope();
            }
            if (this.env == null) {
                this.env = GeometryUtils.createEnvelope((int)0);
            }
            this.env.add(env_geom);
        }
        catch (Throwable ex) {
            throw new SQLException("Can't calculate extent of geometries", ex);
        }
    }

    protected void xFinal() throws SQLException {
        if (this.env == null) {
            this.result();
            return;
        }
        try {
            GeopackageGeometryBuilder builder = GeopackageUtils.createGeometryBuilder();
            builder.setGeometry(this.getConnection(), this.env.getGeometry());
            this.result(builder.build());
        }
        catch (Throwable ex) {
            throw new SQLException("Can't calculate extent of geometries", ex);
        }
    }
}

