/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.geopackage;

import java.io.IOException;
import java.nio.ByteOrder;
import java.sql.Connection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.sqlite.dal.geopackage.ByteWriter;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class GeopackageGeometryBuilder {
    private int srsId;
    private Envelope envelope;
    private Geometry geometry;
    private ByteOrder byteOrder = GeopackageUtils.DEFAULT_BYTE_ORDER;
    private boolean extended;
    private boolean empty;

    GeopackageGeometryBuilder() {
    }

    public void setGeometry(SQLiteConnection conn, Geometry geometry) {
        this.geometry = geometry;
        this.srsId = GeopackageUtils.getSrsId((Connection)conn, geometry);
        if (this.geometry == null || this.geometry.isEmpty()) {
            this.envelope = null;
            this.extended = false;
            this.empty = true;
        } else {
            this.empty = false;
            this.extended = false;
            this.envelope = this.geometry.getEnvelope();
        }
    }

    public byte[] build() {
        try {
            ByteWriter writer = new ByteWriter();
            writer.writeString("GP");
            writer.writeByte((byte)0);
            byte flags = this.buildFlagsByte();
            writer.writeByte(flags);
            writer.setByteOrder(this.byteOrder);
            writer.writeInt(this.srsId);
            this.writeEnvelope(writer);
            int wkbGeometryIndex = writer.size();
            if (!this.empty) {
                byte[] wkb = this.geometry.convertToWKB();
                writer.writeBytes(wkb);
            }
            byte[] bytes = writer.getBytes();
            writer.close();
            return bytes;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Can't build geometry bytes", ex);
        }
    }

    private byte buildFlagsByte() {
        byte flag = 0;
        int binaryType = this.extended ? 1 : 0;
        flag = (byte)(flag + (binaryType << 5));
        int emptyValue = this.empty ? 1 : 0;
        flag = (byte)(flag + (emptyValue << 4));
        int envelopeIndicator = this.envelope == null ? 0 : GeopackageGeometryBuilder.getIndicator(this.envelope);
        flag = (byte)(flag + (envelopeIndicator << 1));
        int byteOrderValue = this.byteOrder == ByteOrder.BIG_ENDIAN ? 0 : 1;
        flag = (byte)(flag + byteOrderValue);
        return flag;
    }

    public static int getIndicator(Envelope envelope) {
        int indicator = 1;
        if (envelope.hasZ()) {
            ++indicator;
        }
        if (envelope.hasM()) {
            indicator += 2;
        }
        return indicator;
    }

    private void writeEnvelope(ByteWriter writer) throws IOException {
        if (this.envelope != null) {
            writer.writeDouble(this.envelope.getMinimum(0));
            writer.writeDouble(this.envelope.getMaximum(0));
            writer.writeDouble(this.envelope.getMinimum(1));
            writer.writeDouble(this.envelope.getMaximum(1));
            if (this.envelope.hasZ()) {
                writer.writeDouble(this.envelope.getMinimum(2));
                writer.writeDouble(this.envelope.getMaximum(2));
            }
        }
    }
}

