/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.operations;

import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CalculateEnvelopeOfColumnOperation;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.gvsig.sqlite.dal.geopackage.index.GeopackageIndex;

public class SQLiteCalculateEnvelopeOfColumnOperation
extends CalculateEnvelopeOfColumnOperation {
    public SQLiteCalculateEnvelopeOfColumnOperation(JDBCHelper helper, FeatureType featureType, OperationsFactory.TableReference table, String columnName, String baseFilter, Envelope limit, IProjection crs) {
        super(helper, featureType, table, columnName, baseFilter, limit, crs);
    }

    public Envelope calculateEnvelopeOfColumn(JDBCConnection conn) throws DataException {
        try {
            FeatureAttributeDescriptor attr = this.featureType.getDefaultGeometryAttribute();
            GeopackageIndex index = GeopackageUtils.getIndexManager().getGeometryIndex(attr);
            Envelope env = index.getEnvelope(conn, this.table.getTable(), attr.getName());
            if (env != null) {
                return env;
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Can't calculate envelope from spatial index", (Throwable)ex);
        }
        return super.calculateEnvelopeOfColumn(conn);
    }
}

