/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.operations;

import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ExecuteOperation;

public class SQLiteExecuteOperation
extends ExecuteOperation {
    public SQLiteExecuteOperation(JDBCHelper helper, String sql) {
        super(helper, sql);
    }

    public Object execute(String sql) {
        Statement st = null;
        ResultSet rs = null;
        try {
            String mode;
            st = this.getConnection().createStatement(sql);
            try {
                String sqltrim = sql.trim();
                mode = StringUtils.left((String)sqltrim, (int)sqltrim.indexOf(32)).toLowerCase();
            }
            catch (Exception e) {
                mode = "unknown";
            }
            switch (mode) {
                case "select": {
                    rs = JDBCUtils.executeQuery((Statement)st, (String)sql);
                    break;
                }
                case "update": {
                    JDBCUtils.executeUpdate((Statement)st, (String)sql);
                    break;
                }
                default: {
                    JDBCUtils.execute((Statement)st, (String)sql);
                }
            }
            if (rs == null) {
                JDBCUtils.closeQuietly((Statement)st);
                return null;
            }
            if (rs.getMetaData().getColumnCount() > 1) {
                return rs;
            }
            if (!rs.next()) {
                rs.close();
                JDBCUtils.closeQuietly((Statement)st);
                return null;
            }
            if (rs.isFirst()) {
                Object res = rs.getObject(1);
                if (!rs.next()) {
                    rs.close();
                    JDBCUtils.closeQuietly((Statement)st);
                    return res;
                }
                rs.close();
                switch (mode) {
                    case "select": {
                        rs = JDBCUtils.executeQuery((Statement)st, (String)sql);
                        break;
                    }
                    case "update": {
                        JDBCUtils.executeUpdate((Statement)st, (String)sql);
                        break;
                    }
                    default: {
                        JDBCUtils.execute((Statement)st, (String)sql);
                    }
                }
            }
            return rs;
        }
        catch (Exception ex) {
            JDBCUtils.closeQuietly(rs);
            JDBCUtils.closeQuietly((Statement)st);
            throw new RuntimeException("Can't execute query [" + sql + "].", ex);
        }
    }
}

