/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateUtils.class);
    private static final Map<String, Map<String, Template>> SQL_TEMPLATES_BY_GROUP = new HashMap<String, Map<String, Template>>();
    private static final String TEMPLATES_FOLDER = "/org/gvsig/sqlite/dal/sqltemplates/";

    private static Map<String, Template> getSqlTemplates(String group) {
        List lines;
        boolean SEARCHING_ITEM = false;
        boolean READING_ITEM = true;
        InputStream sqls = TemplateUtils.class.getResourceAsStream(TEMPLATES_FOLDER + group + ".sql");
        HashMap<String, Template> expecteds = new HashMap<String, Template>();
        try {
            lines = IOUtils.readLines((InputStream)sqls, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't read sql templates for group " + group, ex);
        }
        StringBuilder sb = null;
        Template currentItem = null;
        int lineno = 1;
        int state = 0;
        for (String line : lines) {
            line = line + "\n";
            switch (state) {
                case 0: {
                    if (line.toLowerCase().startsWith("@begin ")) {
                        currentItem = new Template(line.substring(7).trim());
                        sb = new StringBuilder();
                        state = 1;
                        break;
                    }
                    if (line.toLowerCase().startsWith("-- ") || line.toLowerCase().startsWith("@rem") || StringUtils.isBlank((CharSequence)line)) break;
                    throw new IllegalStateException("Syntax error at '" + group + "', line " + lineno + ".");
                }
                case 1: {
                    if (line.toLowerCase().startsWith("@end ")) {
                        String found = line.substring(5).trim();
                        if (!StringUtils.equals((CharSequence)currentItem.getName(), (CharSequence)found)) {
                            throw new IllegalStateException("Syntax error at '" + group + "', line " + lineno + ", expected @end " + currentItem.getName() + ", and found " + line + ".");
                        }
                        String s = sb.toString();
                        if (s.endsWith("\n")) {
                            s = s.substring(0, s.length() - 1);
                        }
                        currentItem.setCode(s);
                        expecteds.put(currentItem.getName(), currentItem);
                        state = 0;
                        break;
                    }
                    if (line.toLowerCase().startsWith("-- ") || line.toLowerCase().startsWith("@rem")) break;
                    if (line.toLowerCase().startsWith("@param ")) {
                        currentItem.addParameter(line.substring(7).trim());
                        break;
                    }
                    if (line.toLowerCase().startsWith("@const ")) {
                        String s = line.substring(7).trim();
                        String[] ss = StringUtils.split((String)s, (String)"=");
                        currentItem.addConstant(ss[0].trim(), ss[1].trim());
                        break;
                    }
                    sb.append(line);
                }
            }
            ++lineno;
        }
        if (state != 0) {
            throw new IllegalStateException("Syntax error at '" + group + "', expected @end " + currentItem.getName() + " and found EOF .");
        }
        return expecteds;
    }

    public static String getSqlTemplate(String group, String sqlId, Object ... args) {
        Template template;
        if (SQL_TEMPLATES_BY_GROUP.get(group) == null) {
            SQL_TEMPLATES_BY_GROUP.put(group, TemplateUtils.getSqlTemplates(group));
        }
        if ((template = SQL_TEMPLATES_BY_GROUP.get(group).get(sqlId)) == null) {
            return null;
        }
        return template.getCode(args);
    }

    private static class Template {
        List<String> parameters;
        Map<String, String> constants;
        String code;
        String name;

        public Template(String name) {
            this.name = name;
            this.parameters = new ArrayList<String>();
            this.constants = new HashMap<String, String>();
            this.code = null;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void addParameter(String parameter) {
            this.parameters.add(parameter);
        }

        public void addConstant(String name, String value) {
            this.constants.put(name, value);
        }

        public String getName() {
            return this.name;
        }

        public String getCode(Object ... params) {
            if (this.parameters.isEmpty()) {
                return String.format(this.code, params);
            }
            String s = this.code;
            for (int i = 0; i < this.parameters.size(); ++i) {
                s = s.replace("%" + this.parameters.get(i) + "$", "%" + (i + 1) + "$");
            }
            for (Map.Entry<String, String> entry : this.constants.entrySet()) {
                String cname = entry.getKey();
                String cvalue = entry.getValue();
                s = s.replace("%" + cname + "$s", cvalue);
            }
            if (ArrayUtils.isEmpty((Object[])params)) {
                return s;
            }
            s = String.format(s, params);
            return s;
        }

        public String toString() {
            return this.name;
        }
    }
}

