/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.TableSorter;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.gui.panels.InfoCRSPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoAuthCRSpanel
extends JPanel
implements ActionListener,
KeyListener {
    public static final Logger logger = LoggerFactory.getLogger(NoAuthCRSpanel.class);
    private static final long serialVersionUID = 1L;
    private JRadioButton codeRadioButton = null;
    private JRadioButton nameRadioButton = null;
    private JPanel groupRadioButton = null;
    public TableSorter sorter = null;
    public JTable jTable = null;
    private JScrollPane jScrollPane = null;
    private JButton searchButton = null;
    private JButton infoCrs = null;
    private JTextField searchTextField = null;
    public DefaultTableModel dtm = null;
    private int codeCRS = -1;
    public String key;
    String cadWKT;
    public int selectedRowTable = -1;
    public EpsgConnection connect = null;

    public NoAuthCRSpanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel pNorth = new JPanel();
        pNorth.setLayout(new GridLayout(2, 1));
        pNorth.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        pNorth.add(this.getGroupRadioButton());
        JPanel pInNorth = new JPanel();
        pInNorth.setLayout(new FlowLayout(0, 10, 1));
        pInNorth.add(this.getSearchButton());
        pInNorth.add(this.getSearchTextField());
        pNorth.add(pInNorth);
        this.add((Component)pNorth, "North");
        this.add((Component)this.getJScrollPane(), "Center");
        JPanel pSouth = new JPanel(new FlowLayout(2, 10, 3));
        pSouth.add(this.getInfoCrs());
        this.add((Component)pSouth, "South");
    }

    public void connection() {
        this.connect = new EpsgConnection();
        this.connect.setConnectionNoAuth();
    }

    private JRadioButton getCodeRadioButton() {
        if (this.codeRadioButton == null) {
            this.codeRadioButton = new JRadioButton();
            this.codeRadioButton.setText(PluginServices.getText((Object)this, (String)"por_codigo"));
            this.codeRadioButton.setSelected(true);
            this.codeRadioButton.addActionListener(this);
        }
        return this.codeRadioButton;
    }

    private JRadioButton getNameRadioButton() {
        if (this.nameRadioButton == null) {
            this.nameRadioButton = new JRadioButton();
            this.nameRadioButton.setText(PluginServices.getText((Object)this, (String)"por_nombre"));
            this.nameRadioButton.addActionListener(this);
        }
        return this.nameRadioButton;
    }

    private JPanel getGroupRadioButton() {
        if (this.groupRadioButton == null) {
            this.groupRadioButton = new JPanel();
            this.groupRadioButton.setLayout(new GridLayout(1, 0));
            this.groupRadioButton.setPreferredSize(new Dimension(500, 30));
            this.groupRadioButton.add(this.getLabel());
            this.groupRadioButton.add(this.getCodeRadioButton());
            this.groupRadioButton.add(this.getNameRadioButton());
        }
        return this.groupRadioButton;
    }

    private JLabel getLabel() {
        JLabel criterio = new JLabel();
        criterio.setPreferredSize(new Dimension(100, 20));
        criterio.setText(PluginServices.getText((Object)this, (String)"criterio_busqueda"));
        return criterio;
    }

    public JButton getInfoCrs() {
        if (this.infoCrs == null) {
            this.infoCrs = new JButton();
            this.infoCrs.setPreferredSize(new Dimension(85, 20));
            this.infoCrs.setText(PluginServices.getText((Object)this, (String)"infocrs"));
            this.infoCrs.setMnemonic('I');
            this.infoCrs.setEnabled(false);
            this.infoCrs.setToolTipText(PluginServices.getText((Object)this, (String)"more_info"));
            this.infoCrs.addActionListener(this);
        }
        return this.infoCrs;
    }

    private JButton getSearchButton() {
        if (this.searchButton == null) {
            this.searchButton = new JButton();
            this.searchButton.setPreferredSize(new Dimension(75, 20));
            this.searchButton.setText(PluginServices.getText((Object)this, (String)"buscar"));
            this.searchButton.setMnemonic('S');
            this.searchButton.addActionListener(this);
        }
        return this.searchButton;
    }

    private JTextField getSearchTextField() {
        if (this.searchTextField == null) {
            this.searchTextField = new JTextField();
            this.searchTextField.setPreferredSize(new Dimension(300, 20));
            this.searchTextField.addKeyListener(this);
        }
        return this.searchTextField;
    }

    public JTable getJTable() {
        if (this.jTable == null) {
            Object[] columnNames = new String[]{PluginServices.getText((Object)this, (String)"codigo"), PluginServices.getText((Object)this, (String)"nombre"), PluginServices.getText((Object)this, (String)"projected"), PluginServices.getText((Object)this, (String)"datum")};
            Object[][] data = new Object[][]{};
            this.dtm = new DefaultTableModel(data, columnNames){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                public Class getColumnClass(int column) {
                    return this.getValueAt(0, column).getClass();
                }
            };
            this.sorter = new TableSorter((TableModel)this.dtm);
            this.jTable = new JTable((TableModel)this.sorter);
            this.sorter.setTableHeader(this.jTable.getTableHeader());
            this.jTable.setCellSelectionEnabled(false);
            this.jTable.setRowSelectionAllowed(true);
            this.jTable.setColumnSelectionAllowed(false);
            this.jTable.setSelectionMode(0);
            TableColumn column = null;
            for (int i = 0; i < 4; ++i) {
                column = this.jTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(80);
                    continue;
                }
                if (i == 2) {
                    column.setPreferredWidth(50);
                    continue;
                }
                column.setPreferredWidth(175);
            }
        }
        return this.jTable;
    }

    public void setCodeCRS(int code) {
        this.codeCRS = code;
    }

    public int getCodeCRS() {
        return this.codeCRS;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(500, 150));
            this.jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"CRS")), BorderFactory.createEmptyBorder(5, 5, 5, 5)), this.jScrollPane.getBorder()));
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.getSearchTextField() && e.getKeyCode() == 10) {
            this.searchButton();
        }
    }

    private void searchButton() {
        this.searchTextField.setBackground(Color.white);
        boolean not_numeric = false;
        if (this.searchTextField.getText().equals("")) {
            this.searchTextField.setBackground(new Color(255, 204, 204));
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"fill_name"), "Warning...", 2);
        } else {
            int numRow = this.dtm.getRowCount();
            while (numRow != 0) {
                this.dtm.removeRow(--numRow);
            }
            if (this.codeRadioButton.isSelected() && this.searchTextField.getText().length() != this.searchTextField.getText().replaceAll("[^0-9]", "").length()) {
                not_numeric = true;
            }
            ResultSet result = null;
            if (this.codeRadioButton.isSelected() && !not_numeric) {
                this.key = this.searchTextField.getText();
                int code = Integer.parseInt(this.key);
                String sentence = "SELECT crs_code, crs_wkt, crs_proj, crs_geog, crs_datum FROM NOAUTHCRS WHERE crs_code = " + code;
                result = Query.select((String)sentence, (Connection)this.connect.getConnection());
                Object[] data = new Object[4];
                try {
                    while (result.next()) {
                        data[0] = result.getString("crs_code");
                        data[1] = result.getString("crs_wkt");
                        String proj = result.getString("crs_proj");
                        if (!proj.equals("")) {
                            data[1] = proj;
                            data[2] = PluginServices.getText((Object)this, (String)"si");
                        } else {
                            data[1] = result.getString("crs_geog");
                            data[2] = PluginServices.getText((Object)this, (String)"no");
                        }
                        data[3] = result.getString("crs_datum");
                        this.dtm.addRow(data);
                    }
                }
                catch (SQLException e1) {
                    logger.info("Can't get values' from resulset, sentence=" + sentence + ".", (Throwable)e1);
                }
            } else if (this.nameRadioButton.isSelected()) {
                this.key = this.searchTextField.getText();
                this.key = this.key.toLowerCase();
                String key2 = this.key.substring(0, 1);
                String key3 = this.key.substring(1, this.key.length());
                key2 = key2.toUpperCase();
                String sentence = "SELECT crs_code, crs_wkt, crs_proj, crs_geog, crs_datum FROM NOAUTHCRS WHERE (crs_proj LIKE '%" + this.key + "%') OR (crs_proj LIKE '%" + this.key.toUpperCase() + "%') " + "OR (crs_proj LIKE '%" + key2 + key3 + "%') OR " + "(crs_geog LIKE '%" + this.key + "%') OR (crs_geog LIKE '%" + this.key.toUpperCase() + "%') " + "OR (crs_geog LIKE '%" + key2 + key3 + "%')";
                result = Query.select((String)sentence, (Connection)this.connect.getConnection());
                Object[] data = new Object[4];
                try {
                    while (result.next()) {
                        data[0] = result.getString("crs_code");
                        data[1] = result.getString("crs_wkt");
                        String proj = result.getString("crs_proj");
                        if (!proj.equals("")) {
                            data[1] = proj;
                            data[2] = PluginServices.getText((Object)this, (String)"si");
                        } else {
                            data[1] = result.getString("crs_geog");
                            data[2] = PluginServices.getText((Object)this, (String)"no");
                        }
                        data[3] = result.getString("crs_datum");
                        this.dtm.addRow(data);
                    }
                }
                catch (SQLException e1) {
                    logger.info("Can't get values from resulset, sentence=" + sentence + ".", (Throwable)e1);
                }
            }
            int numr = this.dtm.getRowCount();
            if (not_numeric) {
                JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"numeric_format"), "Warning...", 2);
                this.searchTextField.setText("");
            } else if (numr == 0) {
                JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"no_results"), "Warning...", 2);
            } else {
                this.getJTable().setRowSelectionInterval(0, 0);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getSearchButton()) {
            this.searchTextField.setBackground(Color.white);
            if (this.searchTextField.getText().equals("")) {
                this.searchTextField.setBackground(new Color(255, 204, 204));
                JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"fill_name"), "Warning...", 2);
            } else {
                this.searchButton();
            }
        }
        if (e.getSource() == this.getCodeRadioButton()) {
            this.searchTextField.setText("");
            this.codeRadioButton.setSelected(true);
            this.nameRadioButton.setSelected(false);
        }
        if (e.getSource() == this.getNameRadioButton()) {
            this.searchTextField.setText("");
            this.nameRadioButton.setSelected(true);
            this.codeRadioButton.setSelected(false);
        }
        if (e.getSource() == this.getInfoCrs()) {
            InfoCRSPanel info = new InfoCRSPanel("CRS", this.getCodeCRS());
            PluginServices.getMDIManager().addWindow((IWindow)info);
        }
    }

    public ICrs getProjection() {
        try {
            ICrs crs = new CrsFactory().getCRS("CRS:" + this.getCodeCRS());
            return crs;
        }
        catch (CrsException e) {
            logger.info("Can't create USR CRS with code " + this.getCodeCRS() + ".", (Throwable)e);
            return null;
        }
    }

    public void setWKT() {
        int code = this.getCodeCRS();
        String sentence = "SELECT crs_wkt FROM NOAUTHCRS WHERE crs_code = " + code;
        ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        try {
            result.next();
            this.cadWKT = result.getString("crs_wkt");
            this.cadWKT = this.cadWKT.substring(0, this.cadWKT.length() - 1) + ", AUTHORITY[\"CRS\"," + code + "]]";
        }
        catch (SQLException e1) {
            logger.info("Can't get values from resulset, sentence=" + sentence + ".", (Throwable)e1);
        }
    }

    public String getWKT() {
        return this.cadWKT;
    }

    public void setProjection(IProjection crs) {
    }
}

