/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.preferences;

import java.awt.BorderLayout;
import java.io.File;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.preferences.JCRSPreferencesPageView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.packageutils.PackageInfo;
import org.gvsig.tools.packageutils.PackageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSPreferencesPage
extends AbstractPreferencePage {
    private static final Logger logger = LoggerFactory.getLogger(JCRSPreferencesPage.class);
    private static final long serialVersionUID = -7838901334080793221L;
    private JCRSPreferencesPageView preferences;
    private DynObject pluginProperties;
    private PluginServices plugin;

    public JCRSPreferencesPage() {
        this.initComponents();
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        PluginsManager pluginManager = PluginsLocator.getManager();
        this.plugin = pluginManager.getPlugin((Object)this);
        this.pluginProperties = this.plugin.getPluginProperties();
        this.preferences = new JCRSPreferencesPageView();
        this.preferences.lblHeader.setText(i18n.getTranslation("_Select_the_EPSG_data_base_to_use"));
        this.preferences.chkUseMomoryChacheForCRSs.setText(i18n.getTranslation("_Use_cache_for_CRSs"));
        this.setLayout(new BorderLayout());
        this.add(this.preferences, "North");
        this.preferences.lblDatabaseInitializationMode.setText(i18n.getTranslation("_When_initializing_the_EPSG_database"));
        DefaultComboBoxModel<String> modelCombo = new DefaultComboBoxModel<String>();
        modelCombo.addElement(i18n.getTranslation("_On_start_in_background"));
        modelCombo.addElement(i18n.getTranslation("_On_start_in_foreground"));
        modelCombo.addElement(i18n.getTranslation("_On_first_use"));
        this.preferences.cboDatabaseInitializationMode.setModel(modelCombo);
        this.initializeValues();
    }

    public void storeValues() throws StoreException {
        ListItem item = (ListItem)this.preferences.lstBBDD.getSelectedValue();
        if (item == null) {
            return;
        }
        this.pluginProperties.setDynValue("epsgDatabase", (Object)item.getEPSGFile());
        this.pluginProperties.setDynValue("useMemoryCacheForCRSs", (Object)this.preferences.chkUseMomoryChacheForCRSs.isSelected());
        this.pluginProperties.setDynValue("databaseInitializationMode", (Object)this.preferences.cboDatabaseInitializationMode.getSelectedIndex());
        this.plugin.savePluginProperties();
    }

    public void setChangesApplied() {
    }

    public String getID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("jCRS_preferences");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        PackageManager pkgManager = ToolsLocator.getPackageManager();
        File dbfolder = CrsFactory.getDataBaseFolder();
        File epsgFolders = new File(dbfolder, "EPSG");
        Collection files = FileUtils.listFiles((File)epsgFolders, (String[])new String[]{"info"}, (boolean)true);
        DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
        File currentEPSG = this.getCurrentEPSG();
        int selectedOption = 0;
        int n = 0;
        for (File f : files) {
            if (!f.getName().equals("package.info")) continue;
            try {
                PackageInfo pkginfo = pkgManager.createPackageInfo(f);
                File epsgdb = new File(f.getParentFile(), "EPSG.sql");
                epsgdb = this.makeRelative(dbfolder, epsgdb);
                model.addElement(new ListItem(pkginfo, epsgdb));
                if (epsgdb.equals(currentEPSG)) {
                    selectedOption = n;
                }
                ++n;
            }
            catch (BaseException ex) {
                logger.warn("Can't load package information from '" + f.getAbsolutePath() + "'.", (Throwable)ex);
            }
        }
        this.preferences.lstBBDD.setModel(model);
        this.preferences.lstBBDD.setSelectedIndex(selectedOption);
        boolean currentUseChacheForCRSs = BooleanUtils.isTrue((Boolean)((Boolean)this.pluginProperties.getDynValue("useMemoryCacheForCRSs")));
        this.preferences.chkUseMomoryChacheForCRSs.setSelected(currentUseChacheForCRSs);
        this.preferences.cboDatabaseInitializationMode.setSelectedIndex((Integer)this.pluginProperties.getDynValue("databaseInitializationMode"));
    }

    private File makeRelative(File parent, File file) {
        String parent_path = parent.getAbsolutePath();
        if (!parent_path.endsWith(File.separator)) {
            parent_path = parent_path + File.separator;
        }
        if (file.getAbsolutePath().startsWith(parent_path)) {
            file = new File(file.getAbsolutePath().substring(parent_path.length()));
        }
        return file;
    }

    private File getCurrentEPSG() {
        File dbfolder = CrsFactory.getDataBaseFolder();
        File currentEPSG = null;
        String s = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginProperties.getDynValue("epsgDatabase")), null);
        if (s != null) {
            currentEPSG = new File(s);
            if (!currentEPSG.isAbsolute()) {
                currentEPSG = new File(dbfolder, s);
            }
            currentEPSG = this.makeRelative(dbfolder, currentEPSG);
        }
        return currentEPSG;
    }

    public void initializeDefaults() {
    }

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"jcrs-preferences");
    }

    public boolean isValueChanged() {
        boolean changed;
        File currentEPSG = this.getCurrentEPSG();
        ListItem item = (ListItem)this.preferences.lstBBDD.getSelectedValue();
        if (item == null && currentEPSG == null) {
            return false;
        }
        if (item == null || currentEPSG == null) {
            return true;
        }
        boolean bl = changed = !currentEPSG.equals(item.getEPSGFile());
        if (!changed) {
            boolean currentUseChacheForCRSs = BooleanUtils.isTrue((Boolean)((Boolean)this.pluginProperties.getDynValue("useMemoryCacheForCRSs")));
            if (this.preferences.chkUseMomoryChacheForCRSs.isSelected() != currentUseChacheForCRSs) {
                changed = true;
            }
        }
        if (!changed) {
            int n = this.preferences.cboDatabaseInitializationMode.getSelectedIndex();
            changed = n != (Integer)this.pluginProperties.getDynValue("databaseInitializationMode");
        }
        return changed;
    }

    public boolean isResizeable() {
        return true;
    }

    private class ListItem {
        private PackageInfo pkg;
        private File epsgFile;

        ListItem(PackageInfo pkg, File epsgFile) {
            this.pkg = pkg;
            this.epsgFile = epsgFile;
        }

        public File getEPSGFile() {
            return this.epsgFile;
        }

        public PackageInfo getPackageInfo() {
            return this.pkg;
        }

        public String toString() {
            return this.pkg.getName();
        }
    }
}

