/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.file.imageio;

import java.io.File;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.raster.OpenRasterStoreParameters;
import org.gvsig.fmap.dal.raster.spi.AbstractOpenRasterStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageIOStoreProviderParameters
extends AbstractOpenRasterStoreParameters
implements OpenRasterStoreParameters,
FilesystemStoreParameters {
    protected static final Logger logger = LoggerFactory.getLogger(ImageIOStoreProviderParameters.class);
    public static final String FILE_PARAMTER_NAME = "file";
    protected DelegatedDynObject parameters;

    public ImageIOStoreProviderParameters(String name) {
        this.parameters = (DelegatedDynObject)FileHelper.newParameters((String)(name + "StoreProviderParameters"));
        this.setDynValue("ProviderName", name);
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    public File getFile() {
        return (File)this.getDynValue(FILE_PARAMTER_NAME);
    }

    public void setFile(File file) {
        this.setDynValue(FILE_PARAMTER_NAME, file);
        this.loadWLD(file);
        if (this.getCRS() == null) {
            this.loadPRJ(file);
        }
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.parameters;
    }

    public void setDynValue(String name, Object value) {
        super.setDynValue(name, value);
        if (name.equals(FILE_PARAMTER_NAME)) {
            this.loadWLD((File)value);
        }
    }

    public boolean isTheSameExplorer(DataStoreParameters parameters) {
        return FilesystemStoreParameters.isTheSameExplorer((DataStoreParameters)this, (DataStoreParameters)parameters);
    }
}

