/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.simplehttpserver.commands;

import org.apache.commons.lang3.Range;
import org.gvsig.simplehttpserver.SimpleServer;
import org.gvsig.simplehttpserver.SimpleServerConfig;
import org.gvsig.simplehttpserver.commands.Command;
import org.gvsig.simplehttpserver.commands.CommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand
implements Command {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractCommand.class);
    private final SimpleServer server;
    private final CommandFactory factory;

    public AbstractCommand(CommandFactory factory, SimpleServer server) {
        this.server = server;
        this.factory = factory;
    }

    protected SimpleServerConfig getConfig() {
        return this.server.getConfig();
    }

    @Override
    public SimpleServer getServer() {
        return this.server;
    }

    @Override
    public String getDescription() {
        return this.factory.getDescription().replace("${host}", this.server.getHost());
    }

    @Override
    public String getName() {
        return this.factory.getName();
    }

    @Override
    public Range getNumArgs() {
        return this.factory.getNumArgs();
    }

    @Override
    public String getMimeType() {
        return this.factory.getMimeType();
    }
}

