/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante;

import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.gui.algorithm.DefaultParametersPanel;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.IToolboxRightButtonAction;
import es.unex.sextante.gui.core.NameAndIcon;
import es.unex.sextante.gui.core.ToolboxAction;
import es.unex.sextante.gui.help.HelpElement;
import es.unex.sextante.gui.help.ImageAndDescription;
import es.unex.sextante.gui.modeler.DefaultModelerParametersPanel;
import es.unex.sextante.gui.settings.Setting;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputChart;
import es.unex.sextante.outputs.OutputNumericalValue;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputText;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterVectorLayer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.geoprocess.lib.api.GeoProcess;
import org.gvsig.geoprocess.lib.api.GeoProcessBuiler;
import org.gvsig.geoprocess.lib.api.GeoProcessManager;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.GeoProcessBuilerBase;
import org.gvsig.geoprocess.lib.sextante.gui.settings.GeoprocessSetting;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.kxml2.io.KXmlParser;

public class SextanteGeoProcessManager
implements GeoProcessManager,
IAlgorithmProvider {
    private static final String XML_PARSER_ENCODING = "ISO-8859-1";
    private static String HELP = "help";
    private Map<String, GeoAlgorithm> geoprocesses;
    private I18nManager i18nManager = ToolsLocator.getI18nManager();

    public SextanteGeoProcessManager() {
        this.geoprocesses = new HashMap<String, GeoAlgorithm>();
    }

    public String getTranslation(String label) {
        String text = this.i18nManager.getTranslation(label);
        return text == null ? Sextante.getText((String)label) : text;
    }

    public void registerGeoProcess(GeoProcess geoProcess) {
        if (!(geoProcess instanceof GeoAlgorithm)) {
            throw new IllegalArgumentException("The geoprocess " + geoProcess + " is not an implementation of a sextante GeoAlgorithm, " + "so it is not supported as of now");
        }
        GeoAlgorithm geoAlgorithm = (GeoAlgorithm)geoProcess;
        this.geoprocesses.put(geoAlgorithm.getCommandLineName(), geoAlgorithm);
    }

    public void registerGeoProcess(Class<? extends GeoProcess> geoProcessClazz, Map<String, String> localeStrings) {
        try {
            GeoProcess geoAlgorithm = geoProcessClazz.newInstance();
            this.registerGeoProcess(geoAlgorithm);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error creating a geoprocess instance from the class " + geoProcessClazz, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error creating a geoprocess instance from the class " + geoProcessClazz, e);
        }
    }

    public void initialize() {
    }

    public String getName() {
        return Messages.getText((String)"gv_algorithms");
    }

    public HashMap<String, GeoAlgorithm> getAlgorithms() {
        return new HashMap<String, GeoAlgorithm>(this.geoprocesses);
    }

    public HashMap<String, Class> getCustomModelerParameterPanels() {
        HashMap<String, Class> map = new HashMap<String, Class>();
        Set<String> set = this.getAlgorithms().keySet();
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            map.put(iter.next(), DefaultModelerParametersPanel.class);
        }
        return map;
    }

    public HashMap<String, Class> getCustomParameterPanels() {
        HashMap<String, Class> map = new HashMap<String, Class>();
        Set<Map.Entry<String, GeoAlgorithm>> set = this.getAlgorithms().entrySet();
        for (Map.Entry<String, GeoAlgorithm> entry : set) {
            GeoAlgorithm algorithm = entry.getValue();
            Class<? extends GeoAlgorithmParametersPanel> panelClazz = null;
            if (algorithm instanceof AbstractSextanteGeoProcess) {
                panelClazz = ((AbstractSextanteGeoProcess)algorithm).getCustomParametersPanelClass();
            }
            map.put(entry.getKey(), panelClazz == null ? DefaultParametersPanel.class : panelClazz);
        }
        return map;
    }

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"gvsig-icon16x16");
    }

    public Setting getSettings() {
        return new GeoprocessSetting();
    }

    public void update() {
    }

    public Object getAlgorithmHelp(GeoAlgorithm alg) {
        ImageAndDescription iad;
        String algName = alg.getClass().getSimpleName();
        String helpFileName = algName + "_" + Locale.getDefault().getLanguage() + ".xml";
        String currentLocaleHelp = "help/" + helpFileName;
        InputStream is = alg.getClass().getClassLoader().getResourceAsStream(currentLocaleHelp);
        if (is == null) {
            helpFileName = algName + ".xml";
            currentLocaleHelp = "help/" + helpFileName;
            is = alg.getClass().getClassLoader().getResourceAsStream(currentLocaleHelp);
        }
        if (is == null) {
            return null;
        }
        URL helpURL = alg.getClass().getClassLoader().getResource(currentLocaleHelp);
        String helpBaseURL = helpURL.toString();
        int lastIndex = helpBaseURL.length() - helpFileName.length();
        helpBaseURL = helpBaseURL.substring(0, lastIndex);
        Map<String, HelpElement> elements = this.readHelpElements(is);
        HTMLDoc doc = new HTMLDoc();
        doc.open(alg.getName());
        doc.addHeader(Sextante.getText((String)alg.getName()), 1);
        doc.addHeader(Sextante.getText((String)"Description"), 2);
        HelpElement element = elements.get("DESCRIPTION");
        if (element != null) {
            doc.addParagraph(element.getTextAsFormattedHTML());
            for (int j = 0; j < element.getImages().size(); ++j) {
                ImageAndDescription iad2 = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(helpBaseURL + iad2.getFilename(), iad2.getDescription());
            }
        }
        doc.addHeader(Sextante.getText((String)"Parameters"), 2);
        ParametersSet params = alg.getParameters();
        doc.startUnorderedList();
        for (int i = 0; i < params.getNumberOfParameters(); ++i) {
            Parameter param = params.getParameter(i);
            String sParam = param.getParameterDescription();
            sParam = "<b>" + sParam + "[" + this.getParameterTypeName(param) + "]: </b>";
            element = elements.get(param.getParameterName());
            if (element != null) {
                sParam = sParam + element.getTextAsFormattedHTML();
            }
            doc.addListElement(sParam);
            if (element == null) continue;
            for (int j = 0; j < element.getImages().size(); ++j) {
                iad = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(helpBaseURL + iad.getFilename(), iad.getDescription());
            }
        }
        doc.closeUnorderedList();
        doc.addHeader(Sextante.getText((String)"Outputs"), 2);
        element = elements.get("OUTPUT_DESCRIPTION");
        if (element != null) {
            doc.addParagraph(element.getTextAsFormattedHTML());
            for (int j = 0; j < element.getImages().size(); ++j) {
                ImageAndDescription iad3 = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(helpBaseURL + iad3.getFilename(), iad3.getDescription());
            }
        }
        doc.startUnorderedList();
        OutputObjectsSet oo = alg.getOutputObjects();
        String sOutputType = "";
        for (int i = 0; i < oo.getOutputObjectsCount(); ++i) {
            Output out = oo.getOutput(i);
            String sOutput = out.getDescription();
            if (out instanceof OutputRasterLayer) {
                sOutputType = Sextante.getText((String)"Raster_Layer");
            } else if (out instanceof Output3DRasterLayer) {
                sOutputType = Sextante.getText((String)"3D_Raster_layer");
            } else if (out instanceof OutputVectorLayer) {
                sOutputType = Sextante.getText((String)"Vector_Layer");
                OutputVectorLayer ovl = (OutputVectorLayer)out;
                switch (ovl.getShapeType()) {
                    default: {
                        sOutputType = sOutputType + " - " + Sextante.getText((String)"Any_type");
                        break;
                    }
                    case 1: {
                        sOutputType = sOutputType + " - " + Sextante.getText((String)"Line");
                        break;
                    }
                    case 2: {
                        sOutputType = sOutputType + " - " + Sextante.getText((String)"Polygon");
                        break;
                    }
                    case 0: {
                        sOutputType = sOutputType + " - " + Sextante.getText((String)"Point");
                        break;
                    }
                }
            } else if (out instanceof OutputTable) {
                sOutputType = Sextante.getText((String)"Table");
            } else if (out instanceof OutputChart) {
                sOutputType = Sextante.getText((String)"graph-chart");
            } else if (out instanceof OutputText) {
                sOutputType = Sextante.getText((String)"Text");
            } else if (out instanceof OutputNumericalValue) {
                sOutputType = Sextante.getText((String)"Numerical_value");
            }
            sOutput = "<b>" + sOutput + "[" + sOutputType + "]: </b>";
            element = elements.get(out.getName());
            if (element != null) {
                sOutput = sOutput + element.getTextAsFormattedHTML();
            }
            doc.addListElement(sOutput);
            if (element == null) continue;
            for (int j = 0; j < element.getImages().size(); ++j) {
                ImageAndDescription iad4 = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(helpBaseURL + iad4.getFilename(), iad4.getDescription());
            }
        }
        doc.closeUnorderedList();
        doc.addHeader(Sextante.getText((String)"Additional_information"), 2);
        element = elements.get("ADDITIONAL_INFO");
        if (element != null) {
            doc.addParagraph(element.getTextAsFormattedHTML());
            for (int j = 0; j < element.getImages().size(); ++j) {
                ImageAndDescription iad5 = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(helpBaseURL + iad5.getFilename(), iad5.getDescription());
            }
        }
        doc.addHeader(Sextante.getText((String)"Command_line"), 2);
        String sText = alg.getCommandLineHelp();
        sText = sText.replaceAll("\n", "<br>");
        sText = sText.replace("   ", " &nbsp ");
        doc.addCourierText(sText);
        doc.addParagraph("");
        element = elements.get("EXTENSION_AUTHOR");
        if (element != null) {
            doc.addParagraph("<i>" + Sextante.getText((String)"Algorithm_created_by") + " " + element.getText() + "</i>");
            for (int j = 0; j < element.getImages().size(); ++j) {
                iad = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(helpBaseURL + iad.getFilename(), iad.getDescription());
            }
        }
        if ((element = elements.get("HELP_AUTHOR")) != null) {
            doc.addParagraph("<i>" + Sextante.getText((String)"Help_file_created_by") + " " + element.getText() + "</i>");
            for (int j = 0; j < element.getImages().size(); ++j) {
                iad = (ImageAndDescription)element.getImages().get(j);
                doc.addImageAndDescription(helpBaseURL + iad.getFilename(), iad.getDescription());
            }
        }
        doc.close();
        return doc.getHTMLCode();
    }

    public String getAlgorithmHelpFilename(GeoAlgorithm alg, boolean bForceCurrentLocale) {
        return null;
    }

    public boolean canEditHelp() {
        return false;
    }

    private Map<String, HelpElement> readHelpElements(InputStream is) {
        ArrayList<ImageAndDescription> images = null;
        HashMap<String, HelpElement> elements = new HashMap<String, HelpElement>();
        HelpElement element = null;
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput(is, XML_PARSER_ENCODING);
            int tag = parser.nextTag();
            boolean bOut = false;
            if (parser.getEventType() != 1) {
                while (tag != 1 && !bOut) {
                    switch (tag) {
                        case 2: {
                            String name = parser.getName();
                            if (HELP.equals(name)) break;
                            if ("element".equals(name)) {
                                images = new ArrayList<ImageAndDescription>();
                                String sText = parser.getAttributeValue("", "text");
                                String sName = parser.getAttributeValue("", "name");
                                String sDescription = parser.getAttributeValue("", "description");
                                int iType = Integer.parseInt(parser.getAttributeValue("", "type"));
                                element = new HelpElement();
                                element.setText(sText);
                                element.setName(sName);
                                element.setType(iType);
                                element.setDescription(sDescription);
                                break;
                            }
                            if (!"image".equals(name)) break;
                            ImageAndDescription iad = new ImageAndDescription();
                            String sImageFilename = parser.getAttributeValue("", "file");
                            String sDesc = parser.getAttributeValue("", "description");
                            iad.setDescription(sDesc);
                            iad.setFilename(sImageFilename);
                            images.add(iad);
                            break;
                        }
                        case 3: {
                            String name = parser.getName();
                            if (HELP.equals(name)) {
                                bOut = true;
                                break;
                            }
                            if (!"element".equals(name)) break;
                            element.setImages((ArrayList)images);
                            elements.put(element.getName(), element);
                            break;
                        }
                    }
                    if (bOut) continue;
                    tag = parser.next();
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return elements;
    }

    private String getParameterTypeName(Parameter param) {
        String s = Sextante.getText((String)param.getParameterTypeName().replace(' ', '_'));
        if (param instanceof ParameterVectorLayer) {
            try {
                AdditionalInfoVectorLayer ai = (AdditionalInfoVectorLayer)param.getParameterAdditionalInfo();
                switch (ai.getShapeType()) {
                    default: {
                        s = s + " - " + Sextante.getText((String)"Any_type");
                        break;
                    }
                    case 1: {
                        s = s + " - " + Sextante.getText((String)"Line");
                        break;
                    }
                    case 2: {
                        s = s + " - " + Sextante.getText((String)"Polygon");
                        break;
                    }
                    case 0: {
                        s = s + " - " + Sextante.getText((String)"Point");
                        break;
                    }
                }
            }
            catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
                // empty catch block
            }
        }
        return s;
    }

    public HashMap<NameAndIcon, ArrayList<ToolboxAction>> getToolboxActions() {
        return new HashMap<NameAndIcon, ArrayList<ToolboxAction>>();
    }

    public IToolboxRightButtonAction[] getToolboxRightButtonActions() {
        return new IToolboxRightButtonAction[0];
    }

    public GeoProcessBuiler createGeoProcessBuilder() {
        return new GeoProcessBuilerBase();
    }
}

