/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.lib.sextante.dataObjects;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.dataObjects.AbstractRasterLayer;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.IOutputChannel;
import java.awt.geom.Rectangle2D;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.geoprocess.lib.sextante.dataObjects.RasterDriver;

public class BufferWriteOnlyIRasterLayer
extends AbstractRasterLayer {
    private String m_sFilename;
    private IProjection m_Projection;
    protected RasterDriver m_RasterDriver;

    public void create(String sName, String sFilename, AnalysisExtent ae, int iDataType, int iNumBands, Object crs) {
        RasterDriver rmd = new RasterDriver(ae, iDataType, iNumBands);
        rmd.setName(sName);
        rmd.setNoDataValue(SextanteGUI.getOutputFactory().getDefaultNoDataValue());
        this.m_RasterDriver = rmd;
        this.m_sFilename = sFilename;
        this.m_Projection = (IProjection)crs;
    }

    public void create(String sName, String sFilename, AnalysisExtent ge, int iDataType, Object crs) {
        this.create(sName, sFilename, ge, iDataType, 1, crs);
    }

    public int getDataType() {
        return this.m_RasterDriver.getRasterBuf().getDataType();
    }

    public void setCellValue(int x, int y, int iBand, double dValue) {
        this.m_RasterDriver.setCellValue(x, y, iBand, dValue);
    }

    public void setNoDataValue(double dNoDataValue) {
        this.m_RasterDriver.setNoDataValue(dNoDataValue);
    }

    public void setNoData(int x, int y) {
        this.m_RasterDriver.setNoData(x, y);
    }

    public double getNoDataValue() {
        return this.m_RasterDriver.getNoDataValue();
    }

    public double getCellValueInLayerCoords(int x, int y, int band) {
        return this.m_RasterDriver.getCellValue(x, y, band);
    }

    public int getBandsCount() {
        return this.m_RasterDriver.getRasterBuf().getBandCount();
    }

    public String getName() {
        return this.m_RasterDriver.getName();
    }

    public void postProcess() {
        this.m_RasterDriver.export(this.m_sFilename, this.m_Projection);
    }

    public void open() {
    }

    public void close() {
        this.m_RasterDriver.free();
    }

    public Rectangle2D getFullExtent() {
        return this.m_RasterDriver.getGridExtent().getAsRectangle2D();
    }

    public AnalysisExtent getLayerGridExtent() {
        return this.m_RasterDriver.getGridExtent();
    }

    public double getLayerCellSize() {
        return this.m_RasterDriver.getGridExtent().getCellSize();
    }

    public String getFilename() {
        return this.m_sFilename;
    }

    public Object getCRS() {
        return this.m_Projection;
    }

    public void setName(String name) {
        this.m_RasterDriver.setName(name);
    }

    public Object getBaseDataObject() {
        return this.m_RasterDriver;
    }

    public void free() {
    }

    public IOutputChannel getOutputChannel() {
        return null;
    }

    public Buffer getBuffer() {
        return this.m_RasterDriver.getRasterBuf();
    }
}

