/*
 * Decompiled with CFR 0.152.
 */
package es.idr.teledeteccion.connection;

import es.idr.teledeteccion.connection.epsg.HSQLDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.gvsig.crs.CrsFactory;
import org.hsqldb.jdbc.jdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EpsgConnection
extends jdbcDataSource {
    private static final Logger logger = LoggerFactory.getLogger(EpsgConnection.class);
    Connection connect = null;
    String connectionType = null;

    private void setConnection(Connection connection, String type) {
        this.connect = connection;
        this.connectionType = type;
        logger.debug("Created connection to '" + this.connectionType + "'.");
    }

    public void setConnectionEPSG() {
        HSQLDataSource ds = new HSQLDataSource();
        try {
            this.setConnection(ds.getConnection(), "EPSG");
        }
        catch (SQLException e) {
            logger.warn("Cant get conection from HSQLDataSource.", (Throwable)e);
        }
    }

    public void setConnectionIAU2000() {
        String db = "jdbc:hsqldb:file:" + CrsFactory.getDataBaseFolder().getAbsolutePath() + "/iau2000";
        this.setDatabase(db);
        this.setUser("sa");
        try {
            this.setConnection(super.getConnection(), "IAU2000");
        }
        catch (SQLException e) {
            logger.warn("Can't get conection from database '" + db + "'.", (Throwable)e);
        }
    }

    public void setConnectionEsri() {
        String db = "jdbc:hsqldb:file:" + CrsFactory.getDataBaseFolder().getAbsolutePath() + "/esri";
        this.setDatabase(db);
        this.setUser("sa");
        try {
            this.setConnection(super.getConnection(), "Esri");
        }
        catch (SQLException e) {
            logger.warn("Can't get conection from database '" + db + "'.", (Throwable)e);
        }
    }

    public void setConnectionNoAuth() {
        String db = "jdbc:hsqldb:file:" + CrsFactory.getDataBaseFolder().getAbsolutePath() + "/noauth";
        this.setDatabase(db);
        this.setUser("sa");
        try {
            this.setConnection(super.getConnection(), "NoAuth");
        }
        catch (SQLException e) {
            logger.warn("Can't get conection from database '" + db + "'.", (Throwable)e);
        }
    }

    public void setConnectionUsr() {
        String db = "jdbc:hsqldb:file:" + CrsFactory.getDataBaseFolder().getAbsolutePath() + "/usr";
        this.setDatabase(db);
        this.setUser("sa");
        try {
            this.setConnection(super.getConnection(), "Usr");
        }
        catch (SQLException e) {
            logger.warn("Can't get conection from database '" + db + "'.", (Throwable)e);
        }
    }

    public Connection getConnection() {
        return this.connect;
    }

    public void close() throws SQLException {
        try {
            this.connect.close();
            logger.debug("Shutdown connection to '" + this.connectionType + "' database.");
        }
        catch (Exception ex) {
            logger.warn("Can't shutdown the conexion.", (Throwable)ex);
        }
    }

    public void shutdown() throws SQLException {
        try {
            Statement st = this.connect.createStatement();
            st.execute("SHUTDOWN");
            this.connect.close();
            logger.debug("Shutdown connection to '" + this.connectionType + "' database.");
        }
        catch (Exception ex) {
            logger.warn("Can't shutdown the conexion.", (Throwable)ex);
        }
    }

    public synchronized void update(String expression) throws SQLException {
        Statement st = null;
        st = this.connect.createStatement();
        int i = st.executeUpdate(expression);
        if (i == -1) {
            logger.warn("db(" + this.connectionType + ")  error in statement: " + expression);
        }
        st.close();
    }
}

