/*
 * Decompiled with CFR 0.152.
 */
package es.idr.teledeteccion.connection.epsg;

import es.idr.teledeteccion.connection.epsg.FactoryUsingHSQL;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.epsg.DataSource;
import org.gvsig.crs.CrsFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.hsqldb.jdbc.jdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDataSource
extends jdbcDataSource
implements DataSource {
    private static File tmpDir = null;
    private static final Logger logger = LoggerFactory.getLogger(HSQLDataSource.class);

    public HSQLDataSource() {
        File directory = this.getGtTmpDir();
        if ((directory.isDirectory() || directory.mkdir()) && ((directory = new File(directory, "Cached databases")).isDirectory() || directory.mkdir())) {
            StringBuffer url = new StringBuffer("jdbc:hsqldb:file:");
            String path = directory.getAbsolutePath().replace(File.separatorChar, '/');
            if (path.length() == 0 || path.charAt(0) != '/') {
                url.append('/');
            }
            url.append(path);
            if (url.charAt(url.length() - 1) != '/') {
                url.append('/');
            }
            url.append("EPSG");
            this.setDatabase(url.toString());
        }
        this.setUser("SA");
    }

    private File getGtTmpDir() {
        if (tmpDir == null) {
            tmpDir = new File(CrsFactory.getDataBaseFolder(), "temp-" + HSQLDataSource.getProcessId());
            Runtime.getRuntime().addShutdownHook(new cleanOnShutdown(this));
        }
        return tmpDir;
    }

    private static String getProcessId() {
        String fallback = "time" + System.currentTimeMillis();
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return "pid" + Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public int getPriority() {
        return 20;
    }

    private static boolean dataExists(Connection connection) throws SQLException {
        ResultSet tables = connection.getMetaData().getTables(null, null, "EPSG_%", new String[]{"TABLE"});
        boolean exists = tables.next();
        tables.close();
        return exists;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(true);
    }

    public synchronized Connection getConnection(boolean initialize) throws SQLException {
        String database = this.getDatabase();
        if (StringUtils.isEmpty((CharSequence)database)) {
            throw new SQLException("Can't write to the temporary directory.");
        }
        Connection connection = super.getConnection();
        if (initialize) {
            this.initializeDatabase();
        }
        return connection;
    }

    public synchronized void initializeDatabase() throws SQLException {
        Connection connection = super.getConnection();
        if (HSQLDataSource.dataExists(connection)) {
            return;
        }
        this.initializeDatabase2(connection);
    }

    private void initializeDatabase2(Connection connection) throws SQLException {
        Date t1 = new Date();
        logger.info("Creating temporary cached EPSG database in '" + this.getGtTmpDir().getAbsolutePath() + "' from '" + CrsFactory.getEpsgDatabaseFile() + "'.");
        Statement statement = connection.createStatement();
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Creating EPSG DB");
        try {
            String line;
            int lineCounter = 0;
            File f = CrsFactory.getEpsgDatabaseFile();
            status.setAutoremove(true);
            status.setRangeOfValues(0L, f.length());
            FileInputStream sqlInputStream = new FileInputStream(f);
            FileChannel chanel = sqlInputStream.getChannel();
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)sqlInputStream, "ISO-8859-1"));
            StringBuffer insertStatement = null;
            while ((line = in.readLine()) != null) {
                int length;
                status.setCurValue(chanel.position());
                if ((line = line.trim()).startsWith("-- ") || (length = line.length()) == 0) continue;
                if (line.startsWith("INSERT INTO")) {
                    insertStatement = new StringBuffer(line);
                    continue;
                }
                if (insertStatement != null) {
                    boolean hasMore;
                    int values = insertStatement.length();
                    insertStatement.append(line);
                    boolean bl = hasMore = line.charAt(length - 1) == ',';
                    if (hasMore) {
                        insertStatement.setLength(insertStatement.length() - 1);
                    }
                    line = insertStatement.toString();
                    insertStatement.setLength(values);
                    if (!hasMore) {
                        insertStatement = null;
                    }
                }
                statement.execute(line);
                if (++lineCounter % 100 != 0) continue;
                Thread.yield();
            }
            in.close();
            Date t2 = new Date();
            logger.info("Created temporary EPSG database in " + (t2.getTime() - t1.getTime()) + "ms.");
        }
        catch (IOException exception) {
            throw new SQLException("Can't read the SQL script.", exception);
        }
        finally {
            status.terminate();
            statement.close();
            connection.close();
        }
    }

    public AbstractAuthorityFactory createFactory(FactoryGroup factories) throws SQLException {
        return new FactoryUsingHSQL(factories, this.getConnection());
    }

    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    public static class cleanOnShutdown
    extends Thread {
        private HSQLDataSource ds;

        public cleanOnShutdown(HSQLDataSource ds) {
            this.ds = ds;
        }

        public void run() {
            this.shutdown();
            this.delete();
        }

        private void delete() {
            File folder = tmpDir;
            if (folder == null) {
                return;
            }
            try {
                logger.info("Deleting CRS temporary database folder (" + folder.getAbsolutePath() + ").");
                FileUtils.deleteDirectory((File)folder);
            }
            catch (IOException e) {
                logger.error("Can't delete CRS temporary database folder (" + folder + ".", (Throwable)e);
            }
        }

        private void shutdown() {
            try {
                logger.info("Shutdown the data-base.");
                Connection connection = this.ds.getConnection(false);
                Statement statement = connection.createStatement();
                statement.execute("SHUTDOWN");
                statement.close();
                connection.close();
            }
            catch (Exception ex) {
                logger.error("Can't shutdown the database.", (Throwable)ex);
            }
        }
    }
}

