/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IDatum;
import org.cresques.cts.IProjection;
import org.cresques.geo.ViewPortData;
import org.gdal.osr.SpatialReference;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.gvsig.crs.COperation;
import org.gvsig.crs.CRSDatum;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsWkt;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.Proj4;
import org.gvsig.crs.proj.CrsProj;
import org.gvsig.crs.proj.OperationCrsException;
import org.gvsig.fmap.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrsGT
implements ICrs {
    private static final Logger logger = LoggerFactory.getLogger(CrsGT.class);
    private static final Color basicGridColor = new Color(64, 64, 64, 128);
    private CoordinateReferenceSystem crsGT = null;
    private String proj4String = null;
    private Color gridColor = basicGridColor;
    private String sourceTrParams = null;
    private String targetTrParams = null;
    private CrsProj crsProj = null;
    private CrsProj crsProjBase = null;
    private CrsWkt crsWkt = null;
    private Proj4 proj4 = null;

    public CrsGT(CoordinateReferenceSystem crsGT) {
        this.crsGT = crsGT;
    }

    public int getCode() {
        return Integer.valueOf(this.getAbrev().split(":")[1]);
    }

    public CrsWkt getCrsWkt() {
        if (this.crsWkt == null) {
            this.crsWkt = new CrsWkt(this.crsGT);
        }
        return this.crsWkt;
    }

    public String getWKT() {
        return this.crsGT.toWKT();
    }

    public void setTransformationParams(String SourceParams, String TargetParams) {
        this.sourceTrParams = SourceParams;
        this.targetTrParams = TargetParams;
    }

    public String getSourceTransformationParams() {
        return this.sourceTrParams;
    }

    public String getTargetTransformationParams() {
        return this.targetTrParams;
    }

    public Point2D createPoint(double x, double y) {
        return new Point2D.Double(x, y);
    }

    public void drawGrid(Graphics2D g, ViewPortData vp) {
    }

    public Point2D fromGeo(Point2D gPt, Point2D mPt) {
        return null;
    }

    public String getAbrev() {
        return ((AbstractSingleCRS)this.crsGT).getIdentifiers().iterator().next().toString();
    }

    public ICoordTrans getCT(IProjection dest) {
        try {
            if (dest == this) {
                return null;
            }
            COperation operation = null;
            operation = ((ICrs)dest).getSourceTransformationParams() != null || ((ICrs)dest).getTargetTransformationParams() != null ? new COperation(this, (ICrs)dest, ((ICrs)dest).getTargetTransformationParams(), ((ICrs)dest).getSourceTransformationParams()) : new COperation(this, (ICrs)dest, this.sourceTrParams, this.targetTrParams);
            return operation;
        }
        catch (CrsException e) {
            throw new RuntimeException(e);
        }
    }

    public IDatum getDatum() {
        DefaultGeodeticDatum datumGT = (DefaultGeodeticDatum)((AbstractSingleCRS)this.crsGT).getDatum();
        CRSDatum datum = new CRSDatum(datumGT.getEllipsoid().getSemiMajorAxis(), datumGT.getEllipsoid().getInverseFlattening());
        return datum;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public double getScale(double minX, double maxX, double width, double dpi) {
        double scale = 0.0;
        scale = (maxX - minX) * (dpi / 2.54 * 100.0) / width;
        return scale;
    }

    public double getScale(double minX, double maxX, double minY, double maxY, double width, double dpi) {
        double scale = 0.0;
        double incX = maxX - minX;
        if (!this.isProjected()) {
            double a = this.getDatum().getESemiMajorAxis();
            double invF = this.getDatum().getEIFlattening();
            double meanY = (minY + maxY) / 2.0;
            double radius = 0.0;
            if (invF == Double.POSITIVE_INFINITY) {
                radius = a;
            } else {
                double e2 = 2.0 / invF - Math.pow(1.0 / invF, 2.0);
                radius = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(meanY * Math.PI / 180.0), 2.0)) * Math.cos(meanY * Math.PI / 180.0);
            }
            incX *= Math.PI / 180 * radius;
        }
        scale = incX * (dpi / 2.54 * 100.0) / width;
        return scale;
    }

    public boolean isProjected() {
        return this.crsGT instanceof AbstractDerivedCRS;
    }

    public void setGridColor(Color c) {
        this.gridColor = c;
    }

    public Point2D toGeo(Point2D pt) {
        if (this.isProjected()) {
            double[] x = new double[]{pt.getX()};
            double[] y = new double[]{pt.getY()};
            double[] z = new double[]{0.0};
            try {
                CrsProj.operate(x, y, z, this.getCrsProj(), this.getCrsProjBase());
            }
            catch (OperationCrsException e) {
                throw new RuntimeException(e);
            }
            return new Point2D.Double(x[0], y[0]);
        }
        return pt;
    }

    public String getProj4String() throws CrsException {
        if (this.proj4String == null) {
            this.proj4String = this.getProj4().exportToProj4(this.crsGT);
        }
        return this.proj4String;
    }

    public CoordinateReferenceSystem getCrsGT() {
        return this.crsGT;
    }

    public CrsProj getCrsProj() {
        if (this.crsProj == null) {
            try {
                this.crsProj = new CrsProj(this.getProj4String());
            }
            catch (CrsException e) {
                throw new RuntimeException(e);
            }
        }
        return this.crsProj;
    }

    private CrsProj getCrsProjBase() {
        if (this.crsProjBase == null) {
            AbstractDerivedCRS derivedCRS = (AbstractDerivedCRS)this.crsGT;
            try {
                this.crsProjBase = new CrsProj(this.getProj4().exportToProj4(derivedCRS.getBaseCRS()));
            }
            catch (CrsException e) {
                throw new RuntimeException(e);
            }
        }
        return this.crsProjBase;
    }

    private Proj4 getProj4() {
        if (this.proj4 == null) {
            try {
                this.proj4 = new Proj4();
            }
            catch (CrsException e) {
                throw new RuntimeException(e);
            }
        }
        return this.proj4;
    }

    public String getFullCode() {
        if (this.sourceTrParams == null && this.targetTrParams == null) {
            return this.getAbrev();
        }
        String sourceParams = "";
        String targetParams = "";
        if (this.sourceTrParams != null) {
            sourceParams = this.sourceTrParams;
        }
        if (this.targetTrParams != null) {
            targetParams = this.targetTrParams;
        }
        return this.getAbrev() + ":proj@" + sourceParams + "@" + targetParams;
    }

    public Rectangle2D getExtent(Rectangle2D extent, double scale, double wImage, double hImage, double mapUnits, double distanceUnits, double dpi) {
        double w = 0.0;
        double h = 0.0;
        double wExtent = 0.0;
        double hExtent = 0.0;
        w = wImage / dpi * 2.54;
        h = hImage / dpi * 2.54;
        wExtent = w * scale / mapUnits;
        hExtent = h * scale / mapUnits;
        double xExtent = extent.getCenterX() - wExtent / 2.0;
        double yExtent = extent.getCenterY() - hExtent / 2.0;
        Rectangle2D.Double rec = new Rectangle2D.Double(xExtent, yExtent, wExtent, hExtent);
        return rec;
    }

    public Object clone() throws CloneNotSupportedException {
        return CRSFactory.getCRS((String)this.getFullCode());
    }

    public String export(String format) {
        SpatialReference spatialReference = this.getCrsProj().getSpatialReference();
        if (format.equalsIgnoreCase("proj4")) {
            return spatialReference.ExportToProj4();
        }
        if (format.equalsIgnoreCase("wkt_esri")) {
            if (spatialReference.MorphToESRI() == 0) {
                return spatialReference.ExportToWkt();
            }
            return null;
        }
        return spatialReference.ExportToWkt();
    }
}

