/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.spatialReferenceIdentifyStrategies;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.sql.ResultSet;
import org.apache.commons.lang3.StringUtils;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.AbstractIdentifyStrategy;

public class IdentifyEPSGUsingProj4AndNormalizing
extends AbstractIdentifyStrategy {
    private int accuracy;
    private int best_dist = 1000;
    private int best_code = 0;

    public IdentifyEPSGUsingProj4AndNormalizing() {
        this(5);
    }

    public IdentifyEPSGUsingProj4AndNormalizing(int accuracy) {
        this.accuracy = accuracy;
    }

    public IdentifyEPSGUsingProj4AndNormalizing setAccuracy(int accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public int getBestAccuracy() {
        return this.best_dist;
    }

    public SpatialReference getBest() {
        SpatialReference sr = this.createSpatialReferenceFromEPSGCode(this.best_code);
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SpatialReference identify(SpatialReference sr) {
        block29: {
            String source_sr_name;
            String attr;
            String kind;
            if (this.autoIdentifyEPSG(sr)) {
                return sr;
            }
            String source_proj4 = this.getProj4String(sr);
            this.best_code = 0;
            this.best_dist = 1000;
            if (sr.IsGeographic() == 1) {
                kind = "geographic 2D";
                attr = "GEOGCS";
                source_sr_name = sr.GetAttrValue(attr);
                if (source_sr_name == null) {
                    return null;
                }
                StringUtils.replace((String)source_sr_name.toLowerCase(), (String)"_", (String)" ");
                if (StringUtils.startsWithIgnoreCase((CharSequence)source_sr_name, (CharSequence)"etrs89") || StringUtils.startsWithIgnoreCase((CharSequence)source_sr_name, (CharSequence)"etrs 89") || StringUtils.startsWithIgnoreCase((CharSequence)source_sr_name, (CharSequence)"etrs 1989")) {
                    source_sr_name = "etrs89";
                }
            } else {
                if (sr.IsProjected() != 1) return null;
                kind = "projected";
                attr = "PROJCS";
                source_sr_name = sr.GetAttrValue(attr);
            }
            logger.debug("Source SR name: {}", (Object)source_sr_name);
            sr.StripCTParms();
            String sql = "SELECT coord_ref_sys_code FROM EPSG_COORDINATEREFERENCESYSTEM WHERE coord_ref_sys_kind = '" + kind + "' AND REPLACE(REPLACE(LOWER(coord_ref_sys_name),' / ',' '),'-',' ') LIKE '%" + this.normalizeEPSGSrName(source_sr_name) + "%' AND deprecated = 0";
            logger.debug(sql);
            EpsgConnection conn = null;
            conn = new EpsgConnection();
            conn.setConnectionEPSG();
            ResultSet result2333332 = Query.select(sql, conn.getConnection());
            while (result2333332.next()) {
                int dist;
                int code;
                block28: {
                    String target_sr_name;
                    block27: {
                        code = result2333332.getInt("coord_ref_sys_code");
                        logger.debug("Trying to match EPSG:{}...", (Object)code);
                        SpatialReference target_sr = this.createSpatialReferenceFromEPSGCode(code);
                        target_sr_name = target_sr.GetAttrValue(attr);
                        target_sr.StripCTParms();
                        logger.debug("Target SR name: {}", (Object)target_sr_name);
                        if (source_proj4 == null) break block27;
                        String target_proj4 = target_sr.ExportToProj4();
                        logger.debug("Target proj4: {}", (Object)target_proj4);
                        if (!StringUtils.equals((CharSequence)source_proj4, (CharSequence)target_proj4)) continue;
                        logger.debug("EPSG:{} matches!", (Object)code);
                        SpatialReference sr2 = this.createSpatialReferenceFromEPSGCode(code);
                        if (sr2 == null) break block27;
                        SpatialReference spatialReference = sr2;
                        try {
                            conn.close();
                            return spatialReference;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return spatialReference;
                    }
                    dist = StringUtils.getLevenshteinDistance((CharSequence)this.normalizeEPSGSrName(source_sr_name), (CharSequence)this.normalizeEPSGSrName(target_sr_name));
                    if (dist != 0) break block28;
                    logger.debug("EPSG:{} matches!", (Object)code);
                    SpatialReference sr2 = this.createSpatialReferenceFromEPSGCode(code);
                    if (sr2 == null) break block28;
                    SpatialReference spatialReference = sr2;
                    try {
                        conn.close();
                        return spatialReference;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return spatialReference;
                }
                try {
                    if (dist >= this.best_dist) continue;
                    this.best_dist = dist;
                    this.best_code = code;
                }
                catch (Exception e) {
                    logger.debug("Can't identify wkt.", (Throwable)e);
                }
            }
            try {
                conn.close();
            }
            catch (Exception result2333332) {}
            break block29;
            catch (Exception e222222) {
                try {
                    logger.debug("Can't identify wkt.", (Throwable)e222222);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (Exception e222222) {}
                }
            }
        }
        if (this.best_code <= 0) return null;
        if (this.best_dist > this.accuracy) return null;
        logger.debug("EPSG:{} is the best match (Levenshtein Distance = {}).", (Object)this.best_code, (Object)this.best_dist);
        SpatialReference sr2 = this.createSpatialReferenceFromEPSGCode(this.best_code);
        if (sr2 == null) return null;
        return sr2;
    }
}

