/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.proj.lib.jcrs;

import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.crs.Crs;
import org.gvsig.proj.CoordinateReferenceSystem;
import org.gvsig.proj.CoordinateTransformation;
import org.gvsig.proj.Datum;
import org.gvsig.proj.lib.jcrs.JCRSCoordinateTransformation;
import org.gvsig.proj.lib.jcrs.JCRSDatum;

public class JCRSCoordinateReferenceSystem
implements CoordinateReferenceSystem {
    Crs crs = null;
    String code = null;
    String authorityName = null;
    Datum datum = null;

    JCRSCoordinateReferenceSystem(Crs crs) {
        String[] parts = crs.getAbrev().split(":");
        this.crs = crs;
        this.authorityName = parts[0];
        this.code = parts[1];
        this.datum = new JCRSDatum(this.crs);
    }

    public String getAuthorityName() {
        return this.authorityName;
    }

    public String getCode() {
        return this.code;
    }

    public String getReference() {
        return this.authorityName.concat(":").concat(this.code);
    }

    public String getDefinition() {
        return this.toWKT();
    }

    public String getDescription() {
        return this.toWKT();
    }

    public CoordinateTransformation getTransformation(CoordinateReferenceSystem target) {
        ICoordTrans ct = this.crs.getCT(((JCRSCoordinateReferenceSystem)target).getIProjection());
        return new JCRSCoordinateTransformation(ct);
    }

    public boolean isProjected() {
        return this.crs.isProjected();
    }

    public CoordinateReferenceSystem createGeographic() {
        throw new UnsupportedOperationException();
    }

    public Datum getDatum() {
        return this.datum;
    }

    public Object clone() throws CloneNotSupportedException {
        JCRSCoordinateReferenceSystem other = (JCRSCoordinateReferenceSystem)super.clone();
        return other;
    }

    public String toWKT() {
        return this.crs.getWKT();
    }

    public String toString() {
        return this.toWKT();
    }

    public IProjection getIProjection() {
        return this.crs;
    }
}

