/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.proj.lib.jcrs;

import org.gvsig.crs.Crs;
import org.gvsig.proj.Ellipsoid;

public class JCRSEllipsoid
implements Ellipsoid {
    String name = null;
    double semiMajorAxis = -1.0;
    double semiMinorAxis = -1.0;
    double reciprocalFlattening = -1.0;

    JCRSEllipsoid(Crs jcrs) {
        this.name = jcrs.getCrsWkt().getDatumName();
        String[] spheroid = jcrs.getCrsWkt().getSpheroid();
        this.semiMinorAxis = Double.parseDouble(spheroid[0]);
        this.semiMajorAxis = Double.parseDouble(spheroid[1]);
        this.reciprocalFlattening = Double.parseDouble(spheroid[2]);
    }

    public String getShortName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public double getReciprocalFlattening() {
        return this.reciprocalFlattening;
    }

    public String toString() {
        return "Ellipsoid(" + this.name + "," + this.semiMinorAxis + "," + this.semiMajorAxis + "," + this.reciprocalFlattening + ")";
    }
}

