/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.io.IOException;
import java.nio.Buffer;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.BandPageManager;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;
import org.gvsig.raster.lib.buffer.impl.DefaultBufferNotification;
import org.gvsig.raster.lib.buffer.impl.exceptions.CopyFromBandException;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPaginatedBand
extends AbstractBand
implements Band {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPaginatedBand.class);
    protected Buffer data;
    protected int firstRowOfPage;
    protected int rowsPerPage;
    protected BandPageManager pageManager;
    private boolean loaded;
    protected static final int MAX_PREFERED_SIZE = 0x280000;

    public AbstractPaginatedBand(int rows, int columns, NoData noData, BandPageManager pageManager) {
        this.rows = rows;
        this.columns = columns;
        this.loaded = false;
        this.calculateRowsPerPage();
        this.noData = noData == null ? BufferLocator.getBufferManager().createNoData(null, null) : noData;
        this.pageManager = pageManager;
        DisposeUtils.bind((Disposable)pageManager);
    }

    private void calculateRowsPerPage() {
        this.rowsPerPage = 0x280000 / (this.columns * this.getDataSize());
        if (this.rowsPerPage < 1) {
            this.rowsPerPage = 1;
        }
        if (this.rowsPerPage > this.rows) {
            this.rowsPerPage = this.rows;
        }
    }

    @Override
    public void copyFrom(Band source) throws CopyFromBandException {
        this.doCopyFrom(source);
        this.notifyObservers((Object)new DefaultBandNotification("copy_from_band_notification", new Object[]{source}));
    }

    @Override
    protected void doCopyFrom(Band source) throws CopyFromBandException {
        if (this.getColumns() != source.getColumns() || this.getRows() != source.getRows() || this.getDataType() != source.getDataType()) {
            throw new CopyFromBandException(source, this);
        }
        Object rowBuffer = this.createRowBuffer();
        for (int row = 0; row < this.rows; ++row) {
            source.fetchRow(row, rowBuffer);
            this.putRow(row, rowBuffer);
        }
    }

    @Override
    protected void doCopyFrom(Band source, int row, int column) throws CopyFromBandException {
        if (this.getColumns() <= row + source.getColumns() || this.getRows() <= column + source.getRows() || this.getDataType() != source.getDataType()) {
            throw new CopyFromBandException(source, this);
        }
        Object rowBuffer = source.createRowBuffer();
        for (int r = 0; r < Math.min(this.getRows() - row, source.getRows()); ++r) {
            source.fetchRow(r, rowBuffer);
            System.arraycopy(rowBuffer, 0, this.data, (r + row) * this.getColumns() + column, Math.min(this.getColumns() - column, source.getColumns()));
            this.putRow(r, rowBuffer);
        }
    }

    protected void loadPage(int row) {
        if (this.loaded && row >= this.firstRowOfPage && row < this.firstRowOfPage + this.rowsPerPage) {
            return;
        }
        this.loaded = false;
        if (this.pageManager.isSupportedSave()) {
            this.saveCurrentPage();
        }
        int currentPage = row / this.rowsPerPage;
        this.firstRowOfPage = currentPage * this.rowsPerPage;
        try {
            int rowsInPage = this.rowsPerPage;
            if (this.firstRowOfPage + this.rowsPerPage > this.rows) {
                rowsInPage = this.rows - this.firstRowOfPage;
            }
            this.pageManager.load(this.data, this.firstRowOfPage, rowsInPage, this.getDataType());
            this.loaded = true;
            this.notifyObservers((Object)new DefaultBufferNotification("loaded_page_notification", new Object[]{this}));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't load current page", e);
        }
    }

    protected void saveCurrentPage() {
        try {
            int rowsInPage = this.rowsPerPage;
            if (this.firstRowOfPage + this.rowsPerPage > this.rows) {
                rowsInPage = this.rows - this.firstRowOfPage;
            }
            this.pageManager.save(this.data, this.firstRowOfPage, rowsInPage, this.getDataType());
        }
        catch (UnsupportedOperationException rowsInPage) {
        }
        catch (IOException e) {
            throw new RuntimeException("Can't save current page", e);
        }
    }

    protected abstract int getDataSize();

    @Override
    public boolean isReadOnly() {
        if (this.pageManager == null) {
            return false;
        }
        return !this.pageManager.isSupportedSave();
    }

    @Override
    public boolean isPaginated() {
        return true;
    }

    @Override
    public BandInfo getBandInfo() {
        return this.pageManager == null ? null : this.pageManager.getBandInfo();
    }

    protected int calculateBufferSizeToAllocate(int rows, int columns) {
        return this.rowsPerPage * columns;
    }

    @Override
    public void doDispose() throws BaseException {
        super.doDispose();
        this.data = null;
        DisposeUtils.dispose((Disposable)this.pageManager);
        this.pageManager = null;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }
}

