/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl;

import java.nio.FloatBuffer;
import java.util.Arrays;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandPageManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.impl.AbstractPaginatedBand;
import org.gvsig.raster.lib.buffer.impl.DefaultBandNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedBandFloat
extends AbstractPaginatedBand
implements Band.BandFloat {
    private static final Logger logger = LoggerFactory.getLogger(PaginatedBandFloat.class);

    public PaginatedBandFloat(int rows, int columns, NoData noData, BandPageManager pageManager) {
        super(rows, columns, noData, pageManager);
    }

    public int getDataType() {
        return 4;
    }

    @Override
    protected int getDataSize() {
        return 4;
    }

    public Object get(int row, int column) {
        return Float.valueOf(this.getValue(row, column));
    }

    @Override
    protected void doSet(int row, int column, Object value) {
        this.setValue(row, column, ((Float)value).floatValue());
    }

    @Override
    protected void doFill(Object value) {
        if ((value = this.nullValueToNoData(value)) == null) {
            value = 0;
        }
        for (int row = 0; row < this.rows; row += this.rowsPerPage) {
            this.loadPage(row);
            Arrays.fill((float[])this.data.array(), ((Float)value).floatValue());
        }
    }

    public float getValue(int row, int column) {
        this.loadPage(row);
        return ((FloatBuffer)this.data).get((row - this.firstRowOfPage) * this.columns + column);
    }

    public void setValue(int row, int column, float value) {
        this.doSetValue(row, column, value);
        this.notifyObservers((Object)new DefaultBandNotification("set_band_notification", new Object[]{row, column, Float.valueOf(value)}));
    }

    protected void doSetValue(int row, int column, float value) {
        this.loadPage(row);
        ((FloatBuffer)this.data).put((row - this.firstRowOfPage) * this.columns + column, value);
    }

    public float[] createRowBuffer() {
        return new float[this.getColumns()];
    }

    public void fetchRow(int row, Object rowBuffer) {
        this.loadPage(row);
        float[] source = (float[])this.data.array();
        float[] target = (float[])rowBuffer;
        System.arraycopy(source, (row - this.firstRowOfPage) * this.columns, target, 0, this.columns);
    }

    @Override
    protected void doPutRow(int row, Object rowBuffer) {
        this.loadPage(row);
        float[] source = (float[])rowBuffer;
        float[] target = (float[])this.data.array();
        System.arraycopy(source, 0, target, (row - this.firstRowOfPage) * this.columns, this.columns);
    }

    @Override
    protected void loadPage(int row) {
        if (this.data == null) {
            this.data = FloatBuffer.allocate(this.calculateBufferSizeToAllocate(this.rows, this.columns));
        }
        super.loadPage(row);
    }
}

