/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.impl.statistics;

import org.gvsig.raster.lib.buffer.api.statistics.StatisticsBand;
import org.gvsig.raster.lib.buffer.impl.statistics.StatisticalOperation;

public class VarianceOperation
implements StatisticalOperation {
    double sigmaSquare = 0.0;
    long n = 0L;
    double mean;
    double variance;

    public VarianceOperation(StatisticsBand statisticsBand) {
        this.mean = statisticsBand.getMean();
    }

    @Override
    public void pre() {
    }

    @Override
    public void addValue(Number value) {
        double doubleValue = value.doubleValue();
        this.sigmaSquare += Math.pow(doubleValue - this.mean, 2.0);
        ++this.n;
    }

    @Override
    public void post() {
        this.variance = 0.0;
        if (this.n > 1L) {
            this.variance = this.sigmaSquare / (double)this.n;
        }
    }

    @Override
    public Object getResult() {
        return this.variance;
    }
}

