/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.PyMultiarray;
import com.github.tbekolay.jnumeric.UnaryFunction;
import java.lang.reflect.Array;

final class Arccos
extends UnaryFunction {
    Arccos() {
    }

    @Override
    String docString() {
        return "arccos(a [,r]) returns arccos(a) and stores the result in r if supplied.\n";
    }

    @Override
    public PyMultiarray Double(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); ++i) {
            Array.setDouble(a.data, i, Math.acos(Array.getDouble(a.data, i)));
        }
        return a;
    }

    @Override
    public PyMultiarray ComplexDouble(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); i += 2) {
            double re = Array.getDouble(a.data, i);
            double im = Array.getDouble(a.data, i + 1);
            double re1 = 1.0 + im * im - re * re;
            double im1 = -2.0 * im * re;
            double mag = Math.pow(re1 * re1 + im1 * im1, 0.25);
            double phi = Math.atan2(im1, re1) / 2.0;
            double re2 = mag * Math.cos(phi);
            double im2 = mag * Math.sin(phi);
            double re3 = re - im2;
            double im3 = im + re2;
            double re4 = Math.log(re3 * re3 + im3 * im3) / 2.0;
            double im4 = Math.atan2(im3, re3);
            Array.setDouble(a.data, i, im4);
            Array.setDouble(a.data, i + 1, -re4);
        }
        return a;
    }
}

