/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.PyMultiarray;
import com.github.tbekolay.jnumeric.UnaryFunction;
import java.lang.reflect.Array;

final class Exp
extends UnaryFunction {
    Exp() {
    }

    @Override
    String docString() {
        return "exp(a [,r]) returns exp(a) and stores the result in r if supplied.\n";
    }

    @Override
    public PyMultiarray Double(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); ++i) {
            Array.setDouble(a.data, i, Math.exp(Array.getDouble(a.data, i)));
        }
        return a;
    }

    @Override
    public PyMultiarray ComplexDouble(PyMultiarray a) {
        for (int i = 0; i < Array.getLength(a.data); i += 2) {
            double re = Array.getDouble(a.data, i);
            double im = Array.getDouble(a.data, i + 1);
            double ere = Math.exp(re);
            double cosim = Math.cos(im);
            double sinim = Math.sin(im);
            Array.setDouble(a.data, i, ere * cosim);
            Array.setDouble(a.data, i + 1, ere * sinim);
        }
        return a;
    }
}

