/*
 * Decompiled with CFR 0.152.
 */
package com.github.tbekolay.jnumeric;

import com.github.tbekolay.jnumeric.FormatComplex;
import com.github.tbekolay.jnumeric.FormatFloat;
import com.github.tbekolay.jnumeric.FormatFunction;
import com.github.tbekolay.jnumeric.FormatInteger;
import com.github.tbekolay.jnumeric.FormatObject;
import com.github.tbekolay.jnumeric.PrinterFormat;
import com.github.tbekolay.jnumeric.PyMultiarray;
import com.github.tbekolay.jnumeric.Umath;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public class PyMultiarrayPrinter {
    public static String array2string(PyMultiarray a, int maxLineWidth, int precision, boolean suppressSmall, String separator, boolean arrayOutput) {
        int[] lineFormat;
        FormatFunction format;
        int itemLength;
        int[] shape = PyMultiarray.shapeOf((PyObject)a);
        if (shape.length == 0) {
            return a.__getitem__((PyObject)Py.EmptyTuple).toString();
        }
        int size = shape[0];
        for (int i = 1; i < shape.length; ++i) {
            size *= shape[i];
        }
        if (size == 0) {
            PyInteger[] pyShape = new PyInteger[a.dimensions.length];
            for (int i = 0; i < a.dimensions.length; ++i) {
                pyShape[i] = Py.newInteger((int)a.dimensions[i]);
            }
            return Py.newString((String)"zeros(%s, '%s')").__mod__((PyObject)new PyTuple(new PyObject[]{new PyTuple((PyObject[])pyShape), Py.newString((char)a.typecode())})).toString();
        }
        PyMultiarray data = PyMultiarray.reshape((PyObject)a, new int[]{-1});
        char type = a.typecode();
        int itemsPerLine = shape[shape.length - 1];
        switch (type) {
            case '1': 
            case 'b': 
            case 'i': 
            case 'l': 
            case 's': {
                PrinterFormat intFormat = PyMultiarrayPrinter._integerFormat(data);
                itemLength = intFormat.itemLength;
                format = new FormatInteger(intFormat.format);
                break;
            }
            case 'd': 
            case 'f': {
                PrinterFormat floatFormat = PyMultiarrayPrinter._floatFormat(data, precision, suppressSmall, false);
                itemLength = floatFormat.itemLength;
                format = new FormatFloat(floatFormat.format);
                break;
            }
            case 'D': 
            case 'F': {
                PrinterFormat realFormat = PyMultiarrayPrinter._floatFormat(data.getReal(), precision, suppressSmall, false);
                PrinterFormat imagFormat = PyMultiarrayPrinter._floatFormat(data.getImag(), precision, suppressSmall, true);
                itemLength = realFormat.itemLength + imagFormat.itemLength + 3;
                format = new FormatComplex(realFormat.format, imagFormat.format);
                break;
            }
            case 'O': {
                PrinterFormat objectFormat = PyMultiarrayPrinter._objectFormat(data);
                itemLength = objectFormat.itemLength;
                format = new FormatObject();
                break;
            }
            default: {
                throw Py.ValueError((String)"unprintable array");
            }
        }
        int lineWidth = (itemLength += separator.length()) * itemsPerLine - 1;
        if (lineWidth > maxLineWidth) {
            int lineWidth2;
            int lineWidth1;
            int itemsContinuation;
            int indent = itemLength == 6 ? 8 : 6;
            int itemsFirst = (maxLineWidth + 1) / itemLength;
            if (itemsFirst < 1) {
                itemsFirst = 1;
            }
            if ((itemsContinuation = (maxLineWidth + 1 - indent) / itemLength) < 1) {
                itemsContinuation = 1;
            }
            lineWidth = (lineWidth1 = itemLength * itemsFirst - 1) > (lineWidth2 = itemLength * itemsContinuation + indent - 1) ? lineWidth1 : lineWidth2;
            int numberOfLines = 1 + (itemsPerLine - itemsFirst + itemsContinuation - 1) / itemsContinuation;
            lineFormat = new int[]{numberOfLines, itemsFirst, itemsContinuation, indent, lineWidth};
        } else {
            lineFormat = new int[]{1, itemsPerLine, 0, 0, lineWidth};
        }
        String rawString = PyMultiarrayPrinter._arrayToString(a, format, shape.length, lineFormat, separator, arrayOutput ? 6 : 0, false);
        if (arrayOutput) {
            if (type == 'i' || type == 'd' || type == 'D') {
                return "array(" + rawString + ")";
            }
            return "array(" + rawString + ",'" + type + "')";
        }
        return rawString;
    }

    static PrinterFormat _integerFormat(PyMultiarray a) {
        int minValLength;
        int maxValLength = Umath.maximum.reduce((PyObject)a).toString().length();
        int maxStrLength = maxValLength > (minValLength = Umath.minimum.reduce((PyObject)a).toString().length()) ? maxValLength : minValLength;
        String format = "%" + maxStrLength + "d";
        return new PrinterFormat(format, maxStrLength);
    }

    static PrinterFormat _floatFormat(PyMultiarray a, int precision, boolean suppressSmall, boolean sign) {
        boolean expFormat = false;
        a = (PyMultiarray)a.__abs__();
        double maxVal = Py.py2double((PyObject)Umath.maximum.reduce((PyObject)a));
        double minVal = 0.0;
        if (maxVal > 0.0) {
            minVal = maxVal;
            for (int i = 0; i < a.__len__(); ++i) {
                double temp = Py.py2double((PyObject)a.get(i));
                if (temp == 0.0 || !(temp < minVal)) continue;
                minVal = temp;
            }
            if (maxVal >= 1.0E12) {
                expFormat = true;
            }
            if (!suppressSmall && (minVal < 1.0E-4 || maxVal / minVal > 1000.0)) {
                expFormat = true;
            }
        }
        if (expFormat) {
            boolean largeExp = 0.0 < minVal && minVal < 1.0E-99 || maxVal >= 1.0E100;
            int maxStrLen = 8 + precision + (largeExp ? 1 : 0);
            StringBuffer format = new StringBuffer(sign ? "%+" : "%");
            format.append(maxStrLen + "." + precision + "e");
            if (largeExp) {
                format.append("3");
            }
            return new PrinterFormat(format.toString(), maxStrLen);
        }
        StringBuffer format = new StringBuffer("%." + precision + "f");
        int digitPrecision = 0;
        for (int i = 0; i < a.__len__(); ++i) {
            int trialDp = PyMultiarrayPrinter._digits(Py.py2double((PyObject)a.get(i)), precision, format.toString());
            digitPrecision = trialDp > digitPrecision ? trialDp : digitPrecision;
        }
        precision = digitPrecision < precision ? digitPrecision : precision;
        int maxStrLen = Py.newFloat((double)maxVal).__int__().__str__().__len__() + precision + 2;
        format = new StringBuffer(sign ? "%#+" : "%#");
        format.append(maxStrLen + "." + precision + "f");
        return new PrinterFormat(format.toString(), maxStrLen);
    }

    static PrinterFormat _objectFormat(PyMultiarray a) {
        int itemLength = 0;
        for (int i = 0; i < a.__len__(); ++i) {
            int trialLength = a.get(i).toString().length();
            itemLength = itemLength > trialLength ? itemLength : trialLength;
        }
        return new PrinterFormat("", itemLength);
    }

    static int _digits(double x, int precision, String format) {
        String s = Py.newString((String)format).__mod__((PyObject)Py.newFloat((double)x)).toString();
        int zeros = s.length();
        while (s.charAt(zeros - 1) == '0') {
            --zeros;
        }
        return precision - s.length() + zeros;
    }

    static String _arrayToString(PyMultiarray a, FormatFunction format, int rank, int[] lineFormat, String separator, int baseIndent, boolean indentFirst) {
        StringBuffer s = new StringBuffer();
        int aLength = a.__len__();
        if (rank == 1) {
            String s0 = "[";
            int items = lineFormat[1];
            int indent = indentFirst ? baseIndent : 0;
            int index = 0;
            for (int j = 0; j < lineFormat[0]; ++j) {
                for (int k = 0; k < indent; ++k) {
                    s.append(' ');
                }
                s.append(s0);
                for (int i = 0; i < items; ++i) {
                    s.append(format.format(a.get(index)) + separator);
                    if (++index == aLength) break;
                }
                if (s.charAt(s.length() - 1) == ' ') {
                    s.setCharAt(s.length() - 1, '\n');
                } else {
                    s.append('\n');
                }
                items = lineFormat[2];
                indent = lineFormat[3] + baseIndent;
                s0 = "";
            }
            s.setLength(s.length() - separator.length());
            s.append("]\n");
        } else {
            if (indentFirst) {
                for (int k = 0; k < baseIndent; ++k) {
                    s.append(" ");
                }
            }
            s.append('[');
            String subSep = separator.length() > 1 ? separator.substring(0, separator.length() - 1) + '\n' : "\n";
            for (int i = 0; i < aLength - 1; ++i) {
                s.append(PyMultiarrayPrinter._arrayToString((PyMultiarray)a.get(i), format, rank - 1, lineFormat, separator, baseIndent + 1, i != 0));
                s.append(subSep);
            }
            s.append(PyMultiarrayPrinter._arrayToString((PyMultiarray)a.get(aLength - 1), format, rank - 1, lineFormat, separator, baseIndent + 1, true));
            s.append("]\n");
        }
        s.setLength(s.length() - 1);
        return s.toString();
    }
}

