/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.infobypoint.viewtool;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.util.ColorConversion;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.raster.swing.infobypoint.InfoByPointDataModel;
import org.gvsig.raster.wms.app.wmsclient.infobypoint.MainInfoByPointDialog;
import org.gvsig.raster.wms.app.wmsclient.layer.DynObjectSetWMSInfo;
import org.gvsig.raster.wms.app.wmsclient.layer.FLyrWMS;

public class InfoByPixelPointViewTool
implements PointListener {
    private RasterManager rManager = RasterLocator.getManager();
    private InfoByPointDataModel model = null;
    private ColorConversion conv = null;
    private ViewPort viewPort = null;
    private FLayers layers = null;
    private List<String> list = null;
    private MainInfoByPointDialog dialog = null;
    protected MapControl mapCtrl;
    protected Point2D wcPoint = null;

    public InfoByPixelPointViewTool(MapControl mapCtrl, InfoByPointDataModel model, MainInfoByPointDialog dialog) {
        this.mapCtrl = mapCtrl;
        this.model = model;
        this.dialog = dialog;
        this.conv = this.rManager.getColorConversion();
        this.viewPort = mapCtrl.getViewPort();
        this.layers = mapCtrl.getMapContext().getLayers();
        this.list = new ArrayList<String>();
    }

    public void point(PointEvent event) {
        block10: {
            Point2D point2D = event.getPoint();
            BufferedImage image = this.mapCtrl.getImage();
            int value = image.getRGB((int)point2D.getX(), (int)point2D.getY());
            int r = value >> 16 & 0xFF;
            int g = value >> 8 & 0xFF;
            int b = value & 0xFF;
            double[] cmyk = this.conv.RGBtoCMYK(r & 0xFF, g & 0xFF, b & 0xFF, 1.0);
            double[] hsl = this.conv.RGBtoHSL(r & 0xFF, g & 0xFF, b & 0xFF);
            hsl[0] = (int)(255.0 * hsl[0] / 360.0 + 0.5);
            hsl[2] = (int)(hsl[2] * 255.0 + 0.5);
            hsl[1] = (int)(hsl[1] * 255.0 + 0.5);
            Point2D mapPoint = this.viewPort.toMapPoint(point2D);
            this.model.setARGB(r, g, b);
            this.model.setCMYK(cmyk);
            this.model.setHSL(hsl[0], hsl[1], hsl[2]);
            this.model.setViewPoint(point2D.getX(), point2D.getY());
            this.model.setWorldPoint(mapPoint.getX(), mapPoint.getY());
            this.list.clear();
            FLyrWMS selected = null;
            for (FLayer lyr : this.layers.getVisibles()) {
                FLyrWMS raster;
                if (!(lyr instanceof FLyrWMS) || !(raster = (FLyrWMS)lyr).isInside(mapPoint)) continue;
                this.list.add(raster.getName());
                if (!raster.isActive()) continue;
                selected = raster;
            }
            if (selected != null) {
                Point2D rasterPoint = selected.getDataStore().worldToRaster(mapPoint);
                this.model.setNumberOfBands(selected.getDataStore().getBandCount());
                this.model.setBandValues(this.getBandValues(selected.getDataStore(), rasterPoint));
                this.model.setPixelPoint(rasterPoint.getX(), rasterPoint.getY());
                Point p = new Point();
                p.setLocation(point2D.getX(), point2D.getY());
                try {
                    DynObjectSetWMSInfo dos = (DynObjectSetWMSInfo)selected.getInfo(p, 0.0, null, true);
                    String txt = dos.getInfoElement();
                    if (dos.getTypeInfo().compareTo("text/plain") == 0) {
                        this.dialog.setWMSInfoText(txt, dos.getTypeInfo());
                        break block10;
                    }
                    if (dos.getTypeInfo().compareTo("text/html") == 0) {
                        int beginIndex = txt.indexOf("<html");
                        if (beginIndex > 0) {
                            txt = txt.substring(beginIndex, txt.length());
                        }
                        this.dialog.setWMSInfoText(txt, "text/html");
                        break block10;
                    }
                    if (dos.getTypeInfo().endsWith("vnd.ogc.gml") || dos.getTypeInfo().compareTo("text/xml") == 0) {
                        this.dialog.setWMSInfoText(txt, "text/xml");
                        break block10;
                    }
                    this.dialog.setWMSInfoText(txt, "text/html");
                }
                catch (LoadLayerException e) {
                    e.printStackTrace();
                }
                catch (DataException e) {
                    e.printStackTrace();
                }
            } else {
                this.list.clear();
                this.list.add("...");
                this.model.setNumberOfBands(0);
                this.model.setBandValues(new double[]{Double.NaN});
                this.model.setPixelPoint(-1.0, -1.0);
            }
        }
        this.model.setLayerList(this.list);
        this.model.notifyObservers();
    }

    private double[] getBandValues(RasterDataStore dataStore, Point2D pxPoint) {
        double[] res = new double[dataStore.getBandCount()];
        int pos = 0;
        try {
            int i;
            if (dataStore.getDataType()[0] >= 0 && dataStore.getDataType()[0] <= 3) {
                for (i = 0; i < dataStore.getBandCount(); ++i) {
                    int val = (Integer)dataStore.getData((int)pxPoint.getX(), (int)pxPoint.getY(), i);
                    res[pos] = dataStore.getDataType()[0] == 0 ? (double)(val & 0xFF) : (double)val;
                    ++pos;
                }
            }
            if (dataStore.getDataType()[0] == 4) {
                for (i = 0; i < dataStore.getBandCount(); ++i) {
                    res[pos] = ((Float)dataStore.getData((int)pxPoint.getX(), (int)pxPoint.getY(), i)).doubleValue();
                    ++pos;
                }
            }
            if (dataStore.getDataType()[0] == 5) {
                for (i = 0; i < dataStore.getBandCount(); ++i) {
                    res[pos] = (Double)dataStore.getData((int)pxPoint.getX(), (int)pxPoint.getY(), i);
                    ++pos;
                }
            }
            return res;
        }
        catch (Exception e) {
            for (int i = 0; i < dataStore.getBandCount(); ++i) {
                res[i] = Double.NaN;
            }
            return res;
        }
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }

    public boolean cancelDrawing() {
        return true;
    }

    public Image getImageCursor() {
        return IconThemeHelper.getImage((String)"zoom-pixel-cursor");
    }
}

