/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.shape.swing.panels;

import javax.swing.JComponent;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.shape.service.ExportShapeParameters;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;

public class UseSimplifiedExportWrapper
implements ExportPanel {
    private final ExportPanel wraped;
    private final ExportShapeParameters parameters;
    private final JExportProcessPanel processPanel;

    public UseSimplifiedExportWrapper(ExportPanel wraped, JExportProcessPanel processPanel, ExportParameters parameters) {
        this.wraped = wraped;
        this.parameters = (ExportShapeParameters)parameters;
        this.processPanel = processPanel;
    }

    public String getIdPanel() {
        return this.wraped.getIdPanel();
    }

    public String getTitlePanel() {
        return this.wraped.getTitlePanel();
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        if (this.parameters.getUseSimplifiedExport()) {
            return true;
        }
        return this.wraped.validatePanel();
    }

    public void enterPanel() {
        if (this.parameters.getUseSimplifiedExport()) {
            switch (this.processPanel.getLastAction()) {
                case 0: {
                    this.processPanel.previousPanel();
                    return;
                }
                case 1: {
                    this.processPanel.nextPanel();
                    return;
                }
            }
        }
        this.wraped.enterPanel();
    }

    public void nextPanel() {
        if (this.parameters.getUseSimplifiedExport()) {
            return;
        }
        this.wraped.nextPanel();
    }

    public void previousPanel() {
        if (this.parameters.getUseSimplifiedExport()) {
            return;
        }
        this.wraped.previousPanel();
    }

    public JComponent asJComponent() {
        return this.wraped.asJComponent();
    }
}

