/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.spatial.dialect.sqlserver.convertors.Decoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.GeometryCollectionDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.LineStringDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.MultiLineStringDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.MultiPointDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.MultiPolygonDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.dialect.sqlserver.convertors.PointDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.PolygonDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.SqlServerGeometry;
import org.hibernate.spatial.jts.JTS;
import org.hibernate.spatial.jts.mgeom.MGeometryFactory;

public class Decoders {
    private static final List<Decoder<? extends Geometry>> DECODERS = new ArrayList<Decoder<? extends Geometry>>();

    private static Decoder<? extends Geometry> decoderFor(SqlServerGeometry object) {
        for (Decoder<? extends Geometry> decoder : DECODERS) {
            if (!decoder.accepts(object)) continue;
            return decoder;
        }
        throw new IllegalArgumentException("No decoder for type " + (Object)((Object)object.openGisType()));
    }

    public static Geometry decode(byte[] raw) {
        SqlServerGeometry sqlServerGeom = SqlServerGeometry.deserialize(raw);
        Decoder<? extends Geometry> decoder = Decoders.decoderFor(sqlServerGeom);
        return decoder.decode(sqlServerGeom);
    }

    public static Decoder<? extends Geometry> decoderFor(OpenGisType type) {
        for (Decoder<? extends Geometry> decoder : DECODERS) {
            if (!decoder.accepts(type)) continue;
            return decoder;
        }
        throw new IllegalArgumentException("No decoder for type " + (Object)((Object)type));
    }

    static {
        MGeometryFactory factory = JTS.getDefaultGeomFactory();
        DECODERS.add(new PointDecoder(factory));
        DECODERS.add(new LineStringDecoder(factory));
        DECODERS.add(new PolygonDecoder(factory));
        DECODERS.add(new MultiLineStringDecoder(factory));
        DECODERS.add(new MultiPolygonDecoder(factory));
        DECODERS.add(new MultiPointDecoder(factory));
        DECODERS.add(new GeometryCollectionDecoder(factory));
    }
}

