/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.gui.preference.panel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.gvsig.raster.mainplugin.config.Configuration;
import org.gvsig.raster.util.BasePanel;

public class PreferenceOverviews
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private JComboBox comboBoxRate = null;
    private JComboBox comboBoxNumber = null;
    private JComboBox comboBoxAlgorithm = null;
    private JLabel labelNumber = null;
    private JLabel labelRate = null;
    private JLabel labelAlgorithm = null;

    public PreferenceOverviews() {
        this.init();
        this.translate();
    }

    protected void translate() {
        this.setBorder(BorderFactory.createTitledBorder(this.getText((Object)this, "overviews")));
        this.getLabelNumber().setText(this.getText((Object)this, "num_overviews") + ":");
        this.getLabelRate().setText(this.getText((Object)this, "proporcion_overviews") + ":");
        this.getLabelAlgorithm().setText(this.getText((Object)this, "algorithm") + ":");
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        int posy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = posy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelNumber(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = posy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getComboNumber(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = posy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelRate(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = posy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getComboRate(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = posy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        this.add(this.getLabelAlgorithm(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = posy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 5, 5);
        this.add(this.getComboAlgorithm(), gridBagConstraints);
    }

    private JLabel getLabelAlgorithm() {
        if (this.labelAlgorithm == null) {
            this.labelAlgorithm = new JLabel();
        }
        return this.labelAlgorithm;
    }

    private JLabel getLabelRate() {
        if (this.labelRate == null) {
            this.labelRate = new JLabel();
        }
        return this.labelRate;
    }

    private JLabel getLabelNumber() {
        if (this.labelNumber == null) {
            this.labelNumber = new JLabel();
        }
        return this.labelNumber;
    }

    private JComboBox getComboRate() {
        if (this.comboBoxRate == null) {
            this.comboBoxRate = new JComboBox();
            this.comboBoxRate.setModel(new DefaultComboBoxModel<String>(new String[]{"/2", "/3"}));
        }
        return this.comboBoxRate;
    }

    private JComboBox getComboNumber() {
        if (this.comboBoxNumber == null) {
            this.comboBoxNumber = new JComboBox();
            this.comboBoxNumber.setModel(new DefaultComboBoxModel<String>(new String[]{"2", "3", "4", "5", "6"}));
        }
        return this.comboBoxNumber;
    }

    private JComboBox getComboAlgorithm() {
        if (this.comboBoxAlgorithm == null) {
            this.comboBoxAlgorithm = new JComboBox();
            this.comboBoxAlgorithm.setModel(new DefaultComboBoxModel<String>(new String[]{this.getText((Object)this, "vecino_cercano"), this.getText((Object)this, "media"), this.getText((Object)this, "media_phase")}));
        }
        return this.comboBoxAlgorithm;
    }

    public void initializeDefaults() {
        int pos = 0;
        pos = (Integer)Configuration.getDefaultValue((String)"overviews_number") - 2;
        if (pos < 0 || pos >= this.getComboNumber().getItemCount()) {
            pos = 2;
        }
        this.getComboNumber().setSelectedIndex(pos);
        pos = (Integer)Configuration.getDefaultValue((String)"overviews_rate") - 2;
        if (pos < 0 || pos >= this.getComboRate().getItemCount()) {
            pos = 0;
        }
        this.getComboRate().setSelectedIndex(pos);
        pos = (Integer)Configuration.getDefaultValue((String)"overviews_resampling_algorithm");
        int type = 1;
        switch (pos) {
            case 0: {
                type = 0;
                break;
            }
            case 3: {
                type = 2;
            }
        }
        this.getComboAlgorithm().setSelectedIndex(type);
    }

    public void initializeValues() {
        int pos = 0;
        pos = Configuration.getValue((String)"overviews_number", (Integer)4) - 2;
        if (pos < 0 || pos >= this.getComboNumber().getItemCount()) {
            pos = 2;
        }
        this.getComboNumber().setSelectedIndex(pos);
        pos = Configuration.getValue((String)"overviews_rate", (Integer)2) - 2;
        if (pos < 0 || pos >= this.getComboRate().getItemCount()) {
            pos = 0;
        }
        this.getComboRate().setSelectedIndex(pos);
        pos = Configuration.getValue((String)"overviews_resampling_algorithm", (Integer)1);
        int type = 1;
        switch (pos) {
            case 0: {
                type = 0;
                break;
            }
            case 3: {
                type = 2;
            }
        }
        this.getComboAlgorithm().setSelectedIndex(type);
    }

    public void storeValues() {
        if (this.getComboRate().getSelectedIndex() > -1) {
            Configuration.setValue((String)"overviews_rate", (Object)(this.getComboRate().getSelectedIndex() + 2));
        }
        if (this.getComboNumber().getSelectedIndex() > -1) {
            Configuration.setValue((String)"overviews_number", (Object)(this.getComboNumber().getSelectedIndex() + 2));
        }
        int type = 1;
        switch (this.getComboAlgorithm().getSelectedIndex()) {
            case 0: {
                type = 0;
                break;
            }
            case 2: {
                type = 3;
            }
        }
        Configuration.setValue((String)"overviews_resampling_algorithm", (Object)type);
    }
}

