/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.enhanced;

import javax.swing.Icon;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.tools.app.basic.raster.process.HistogramProcess;
import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.raster.process.StatisticsProcess;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.EnhancedDialog;

public class EnhancedTocMenuEntry
extends AbstractTocContextMenuAction
implements IGenericToolBarMenuItem,
IProcessActions {
    private static EnhancedTocMenuEntry singleton = null;
    private FLyrRaster lyr = null;

    private EnhancedTocMenuEntry() {
    }

    public static EnhancedTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new EnhancedTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "Enhanced";
    }

    public int getGroupOrder() {
        return 55;
    }

    public int getOrder() {
        return 0;
    }

    public String getText() {
        return Messages.getText((String)"enhanced_rad");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof ILayerState)) {
            return false;
        }
        if (!((ILayerState)selectedItems[0]).isOpen()) {
            return false;
        }
        return !((FLyrRaster)selectedItems[0]).getRender().existColorTable();
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedItems[0]).isActionEnabled(13);
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1 || !(selectedItems[0] instanceof FLyrRaster)) {
            return;
        }
        this.lyr = (FLyrRaster)selectedItems[0];
        if (!this.lyr.getDataStore().getStatistics().isCalculated()) {
            StatisticsProcess.launcher(this.lyr, this);
        } else {
            this.end(null);
        }
    }

    public Icon getIcon() {
        return IconThemeHelper.getImageIcon((String)"layer-enhanced");
    }

    @Override
    public synchronized void end(Object param) {
        if (param == null || param instanceof FLyrRaster) {
            HistogramProcess histogramProcess = new HistogramProcess();
            histogramProcess.setActions(this);
            histogramProcess.addParam("histogramable", this.lyr.getDataStore().getHistogramComputer());
            histogramProcess.start();
        }
        if (param instanceof BufferHistogram) {
            EnhancedDialog enhancedDialog = new EnhancedDialog(this.lyr, 760, 421);
            PluginServices.getMDIManager().addCentredWindow((IWindow)enhancedDialog);
        }
    }

    @Override
    public void interrupted() {
    }
}

