/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.filter.mask;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.grid.FilterUIListener;
import org.gvsig.fmap.dal.coverage.grid.RegistrableFilterListener;
import org.gvsig.gui.beans.datainput.DataInputContainer;
import org.gvsig.gui.beans.datainput.DataInputContainerListener;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;

public class MaskUI
extends JPanel
implements RegistrableFilterListener,
TableModelListener,
ChangeListener,
DataInputContainerListener {
    private static final long serialVersionUID = 4525736825113598035L;
    private TableContainer tableContainer = null;
    private FLyrRaster layer = null;
    private ArrayList<ROI> rois = null;
    private DataInputContainer valueNoData = null;
    private JCheckBox negative = null;
    private JCheckBox transp = null;
    private JLabel warning = null;
    private boolean lastTransp = false;
    private boolean lastInv = false;
    private ArrayList<FilterUIListener> actionCommandListeners = new ArrayList();
    protected Params params = null;

    public MaskUI() {
        this.init(null);
    }

    public void init(Object obj) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.getWarning(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.getInverse(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.getTableContainer(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.getValueNoData(), gridBagConstraints);
    }

    private JCheckBox getInverse() {
        if (this.negative == null) {
            this.negative = new JCheckBox();
            this.negative.setText(RasterToolsUtil.getText(this, "inversa"));
            this.negative.addChangeListener(this);
        }
        return this.negative;
    }

    private JCheckBox getTransparencyActive() {
        if (this.transp == null) {
            this.transp = new JCheckBox();
            this.transp.setText(RasterToolsUtil.getText(this, "transparencia"));
            this.transp.addChangeListener(this);
        }
        return this.transp;
    }

    private DataInputContainer getValueNoData() {
        if (this.valueNoData == null) {
            this.valueNoData = new DataInputContainer();
            this.valueNoData.setLabelText(RasterToolsUtil.getText(this, "value"));
            this.valueNoData.setValue(RasterLibrary.defaultByteNoDataValue + "");
            this.valueNoData.getDataInputField().addValueChangedListener((DataInputContainerListener)this);
        }
        return this.valueNoData;
    }

    public JLabel getWarning() {
        if (this.warning == null) {
            this.warning = new JLabel(RasterToolsUtil.getText(this, "rois_needed"));
            this.warning.setVisible(false);
        }
        return this.warning;
    }

    private TableContainer getTableContainer() {
        if (this.tableContainer == null) {
            String[] columnNames = new String[]{" ", "Nombre", ""};
            int[] columnWidths = new int[]{22, 334, 0};
            this.tableContainer = new TableContainer(columnNames, columnWidths);
            this.tableContainer.setPreferredSize(new Dimension(0, 130));
            this.tableContainer.setModel("CheckBoxModel");
            this.tableContainer.initialize();
            this.tableContainer.setControlVisible(false);
            this.tableContainer.setMoveRowsButtonsVisible(false);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(0).setMinWidth(22);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(0).setMaxWidth(22);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(2).setMinWidth(0);
            this.tableContainer.getTable().getJTable().getColumnModel().getColumn(2).setMaxWidth(0);
            this.tableContainer.getModel().addTableModelListener(this);
        }
        return this.tableContainer;
    }

    public void setRois(ArrayList<ROI> rois) {
        this.rois = rois;
    }

    public void setLayer(FLyrRaster layer) {
        this.layer = layer;
        if (layer == null) {
            return;
        }
        List roisArray = null;
        try {
            roisArray = layer.getRois();
        }
        catch (ROIException e1) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"problems_loading_rois"), null);
        }
        if (roisArray == null || roisArray.size() == 0) {
            this.getWarning().setVisible(true);
        }
        if (roisArray != null) {
            for (int i = 0; i < roisArray.size(); ++i) {
                ROI roi = (ROI)roisArray.get(i);
                Object[] row = new Object[]{"", "", ""};
                boolean active = false;
                if (this.rois != null) {
                    for (int r = 0; r < this.rois.size(); ++r) {
                        if (this.rois.get(r) != roi) continue;
                        active = true;
                        break;
                    }
                }
                row[0] = new Boolean(active);
                row[1] = roi.getName();
                row[2] = new Integer(i);
                try {
                    this.getTableContainer().addRow(row);
                    continue;
                }
                catch (NotInitializeException notInitializeException) {
                    // empty catch block
                }
            }
        }
        if (layer != null) {
            this.getValueNoData().setValue(RasterLibrary.defaultByteNoDataValue + "");
        }
    }

    private List<ROI> getSelectedROIs() {
        if (this.layer == null) {
            return null;
        }
        List roisArray = null;
        try {
            roisArray = this.layer.getRois();
        }
        catch (ROIException rOIException) {
            // empty catch block
        }
        ArrayList<ROI> selected = new ArrayList<ROI>();
        if (roisArray != null) {
            for (int i = 0; i < roisArray.size(); ++i) {
                try {
                    if (!((Boolean)this.tableContainer.getModel().getValueAt(i, 0)).booleanValue()) continue;
                    selected.add((ROI)roisArray.get(i));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return selected;
    }

    public Params getParams() {
        NoData noData = null;
        Number n = null;
        Double d = new Double(this.getValueNoData().getValue());
        if (this.layer != null) {
            switch (this.layer.getDataStore().getDataType()[0]) {
                case 0: {
                    n = new Byte(d.byteValue());
                    break;
                }
                case 2: {
                    n = new Short(d.shortValue());
                    break;
                }
                case 3: {
                    n = new Integer(d.intValue());
                    break;
                }
                case 4: {
                    n = new Float(this.getValueNoData().getValue());
                    break;
                }
                case 5: {
                    n = d;
                }
            }
        }
        noData = RasterLocator.getManager().getDataStructFactory().createNoData(n, n, null);
        this.params = RasterLocator.getManager().createParams("rois", this.getSelectedROIs(), -1, null);
        this.params.setParam("inverse", (Object)new Boolean(this.getInverse().isSelected()), -1, null);
        try {
            this.params.setParam("nodata", (Object)noData, -1, null);
        }
        catch (NumberFormatException e) {
            this.params.setParam("nodata", (Object)RasterLocator.getManager().getDataStructFactory().createDefaultNoData(1, this.layer.getDataStore().getDataType()[0]), -1, null);
        }
        return this.params;
    }

    public void setParams(Params params) {
        this.params = params;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.callStateChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.getTransparencyActive()) && ((JCheckBox)e.getSource()).isSelected() != this.lastTransp) {
            this.callStateChanged();
            this.lastTransp = ((JCheckBox)e.getSource()).isSelected();
        }
        if (e.getSource().equals(this.getInverse()) && ((JCheckBox)e.getSource()).isSelected() != this.lastInv) {
            this.callStateChanged();
            this.lastInv = ((JCheckBox)e.getSource()).isSelected();
        }
    }

    public void actionValueChanged(EventObject e) {
        this.callStateChanged();
    }

    public void addFilterUIListener(FilterUIListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void callStateChanged() {
        for (FilterUIListener listener : this.actionCommandListeners) {
            listener.actionValuesCompleted(new EventObject(this));
        }
    }

    public void removeStateChangedListener(FilterUIListener listener) {
        this.actionCommandListeners.remove(listener);
    }
}

