/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.multiresolution;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toolListeners.StatusBarListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.multiresolution.ResolutionLevelListener;

public class ZoomResolutionLevelTocMenuEntry
extends AbstractTocContextMenuAction
implements PropertyChangeListener,
IGenericToolBarMenuItem {
    private static ZoomResolutionLevelTocMenuEntry singleton = null;

    private ZoomResolutionLevelTocMenuEntry() {
    }

    public static ZoomResolutionLevelTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new ZoomResolutionLevelTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "RasterLayer";
    }

    public int getGroupOrder() {
        return 10;
    }

    public int getOrder() {
        return 90;
    }

    public String getText() {
        return RasterToolsUtil.getText(this, "goto_resolution_level");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (selectedItems[0] instanceof ILayerState) {
            FLyrRaster lyr;
            if (!((ILayerState)selectedItems[0]).isOpen()) {
                return false;
            }
            if (selectedItems[0] instanceof FLyrRaster && (lyr = (FLyrRaster)selectedItems[0]).getDataStore().isTiled()) {
                return true;
            }
        }
        return false;
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        return selectedItems[0] instanceof FLyrRaster;
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        IWindow theView = PluginServices.getMDIManager().getActiveWindow();
        if (!(theView instanceof AbstractViewPanel)) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText(this.getClass(), (String)"window_not_valid"));
            return;
        }
        MapControl mapCtrl = ((AbstractViewPanel)theView).getMapControl();
        StatusBarListener sbl = new StatusBarListener(mapCtrl);
        ResolutionLevelListener rll = new ResolutionLevelListener();
        mapCtrl.addBehavior("zoomResolutionLevel", new Behavior[]{new PointBehavior((PointListener)rll), new MouseMovementBehavior((PointListener)sbl)});
        mapCtrl.setTool("zoomResolutionLevel");
    }

    public Icon getIcon() {
        return RasterToolsUtil.getIcon("layer-zoom-res-level");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public boolean isEnableEvents() {
        return true;
    }
}

