/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.panel;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.gui.util.StatusComponent;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.tools.app.basic.tool.properties.control.EnhancedControl;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.EnhancedBrightnessContrastPanel;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.EnhancedWithTrimPanel;

public class EnhancedPanel
extends AbstractPanel {
    private static final long serialVersionUID = 0L;
    private EnhancedBrightnessContrastPanel contrastPanel = null;
    private EnhancedWithTrimPanel trimPanel = null;
    private EnhancedControl enhancedControl = null;
    private FLyrRaster fLayer = null;

    public EnhancedPanel() {
        this.setLabel(Messages.getText((String)"realce"));
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new GridLayout(1, 2));
        this.add(this.getBrightnessContrastPanel());
        this.add(this.getEnhancedWithTrimPanel());
        this.setPreferredSize(new Dimension(100, 80));
        this.setPriority(60);
    }

    public void initializeUI() {
    }

    public EnhancedBrightnessContrastPanel getBrightnessContrastPanel() {
        if (this.contrastPanel == null) {
            this.contrastPanel = new EnhancedBrightnessContrastPanel();
        }
        return this.contrastPanel;
    }

    public EnhancedWithTrimPanel getEnhancedWithTrimPanel() {
        if (this.trimPanel == null) {
            this.trimPanel = new EnhancedWithTrimPanel();
        }
        return this.trimPanel;
    }

    public void accept() {
        this.enhancedControl.accept();
    }

    public void apply() {
        this.enhancedControl.apply();
    }

    public void cancel() {
        this.enhancedControl.cancel();
    }

    public void setReference(Object ref) {
        super.setReference(ref);
        if (!(ref instanceof FLyrRaster)) {
            return;
        }
        this.fLayer = (FLyrRaster)ref;
        this.actionEnabled();
        RasterFilterList rfl = this.fLayer.getRender().getFilterList();
        this.enhancedControl = new EnhancedControl(this.getPanelGroup(), this, this.fLayer, rfl);
    }

    private void actionEnabled() {
        IRasterLayerActions actions = null;
        if (this.fLayer instanceof IRasterLayerActions) {
            actions = (IRasterLayerActions)this.fLayer;
        }
        if (!actions.isActionEnabled(12)) {
            StatusComponent.setDisabled((JComponent)this.getBrightnessContrastPanel());
        }
        if (!actions.isActionEnabled(13)) {
            StatusComponent.setDisabled((JComponent)this.getEnhancedWithTrimPanel());
        }
        if (actions.isActionEnabled(13) && !actions.isActionEnabled(23)) {
            this.getEnhancedWithTrimPanel().getTrimSlider().setVisible(false);
            this.getEnhancedWithTrimPanel().getTrimCheck().setVisible(false);
        }
        if (!actions.isActionEnabled(12) && !actions.isActionEnabled(13)) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    public void selected() {
    }
}

