/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.raw.tool;

import java.util.Vector;

public class VRTFormatOptions {
    public static final String INTERLEAVING_PIXEL = "Pixel";
    public static final String INTERLEAVING_BAND = "Band";
    public static final String INTERLEAVING_LINE = "Line";
    public static final String DATA_TYPE_BYTE = "Byte";
    public static final String DATA_TYPE_UINT16 = "Uint16";
    public static final String DATA_TYPE_INT16 = "Int16";
    public static final String DATA_TYPE_UINT32 = "UInt32";
    public static final String DATA_TYPE_INT32 = "Int32";
    public static final String DATA_TYPE_FLOAT32 = "Float32";
    public static final String DATA_TYPE_FLOAT64 = "Float64";
    public static final String DATA_TYPE_CINT16 = "CInt16";
    public static final String DATA_TYPE_CINT32 = "CInt32";
    public static final String DATA_TYPE_CFLOAT32 = "CFloat32";
    public static final String DATA_TYPE_CFLOAT64 = "CFloat64";
    public static final String BYTE_ORDER_LSB = "LSB";
    public static final String BYTE_ORDER_MSB = "MSB";
    public static final String OUTPUT_FORMAT_VRT = "VRT";

    public static Vector getDataTypes() {
        Vector<UIOption> vector = new Vector<UIOption>();
        vector.add(new UIOption(DATA_TYPE_BYTE, 8));
        vector.add(new UIOption(DATA_TYPE_UINT32, 16));
        vector.add(new UIOption(DATA_TYPE_INT16, 16));
        vector.add(new UIOption(DATA_TYPE_UINT32, 32));
        vector.add(new UIOption(DATA_TYPE_INT32, 32));
        vector.add(new UIOption(DATA_TYPE_FLOAT32, 32));
        vector.add(new UIOption(DATA_TYPE_FLOAT64, 64));
        vector.add(new UIOption(DATA_TYPE_CINT16, 16));
        vector.add(new UIOption(DATA_TYPE_CINT32, 32));
        vector.add(new UIOption(DATA_TYPE_CFLOAT32, 32));
        vector.add(new UIOption(DATA_TYPE_CFLOAT64, 64));
        return vector;
    }

    public static Vector getByteOrder() {
        Vector<UIOption> vector = new Vector<UIOption>();
        vector.add(new UIOption(BYTE_ORDER_LSB, "LSB (Swapped)"));
        vector.add(new UIOption(BYTE_ORDER_MSB, "MSB (Unswapped)"));
        return vector;
    }

    public static Vector getInterleaving() {
        Vector<UIOption> vector = new Vector<UIOption>();
        vector.add(new UIOption(INTERLEAVING_PIXEL));
        vector.add(new UIOption(INTERLEAVING_BAND));
        vector.add(new UIOption(INTERLEAVING_LINE));
        return vector;
    }

    public static Vector getOutputHeaderFormats() {
        Vector<UIOption> vector = new Vector<UIOption>();
        vector.add(new UIOption(OUTPUT_FORMAT_VRT));
        return vector;
    }

    public static class UIOption {
        private String uiName = null;
        private String vrtOptionName = null;
        private int dataSize = 0;

        public UIOption(String vrtOptionName, String uiName) {
            this.uiName = uiName;
            this.vrtOptionName = vrtOptionName;
        }

        public UIOption(String vrtOptionName) {
            this.uiName = vrtOptionName;
            this.vrtOptionName = vrtOptionName;
        }

        public UIOption(String vrtOptionName, int dataSize) {
            this.uiName = vrtOptionName;
            this.vrtOptionName = vrtOptionName;
            this.dataSize = dataSize;
        }

        public String getUiName() {
            return this.uiName;
        }

        public String getVrtOptionName() {
            return this.vrtOptionName;
        }

        public String toString() {
            return this.uiName;
        }

        public int getDataSize() {
            return this.dataSize;
        }
    }
}

