/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.saveraster.map;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.raster.fmap.tool.SaveRasterListenerImpl;
import org.gvsig.raster.tools.app.basic.tool.saveraster.ui.SaveRasterDialog;
import org.gvsig.raster.tools.app.basic.tool.saveraster.ui.SaveRasterPanel;

public class SaveRasterListener
extends SaveRasterListenerImpl {
    private final Image isaveraster = IconThemeHelper.getImage((String)"rectangle-select-cursor");

    public SaveRasterListener(MapControl mapCtrl) {
        super(mapCtrl);
    }

    public void rectangle(EnvelopeEvent event) {
        super.rectangle(event);
        if (PluginServices.getMainFrame() != null) {
            PluginServices.getMainFrame().enableControls();
        }
        FLayers layers = this.mapCtrl.getMapContext().getLayers();
        SaveRasterDialog saveRaster = null;
        boolean open = false;
        IWindow[] win = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < win.length; ++i) {
            if (!(win[i] instanceof SaveRasterDialog)) continue;
            saveRaster = (SaveRasterDialog)win[i];
            open = true;
        }
        if (saveRaster == null) {
            saveRaster = new SaveRasterDialog(layers, this.mapCtrl);
        }
        ViewPort vp = this.mapCtrl.getViewPort();
        Point2D ini = vp.fromMapPoint(this.rect.getMinimum(0), this.rect.getMinimum(1));
        Point2D fin = vp.fromMapPoint(this.rect.getMaximum(0), this.rect.getMaximum(1));
        if (Math.abs(fin.getY() - ini.getY()) > 10.0 && Math.abs(fin.getX() - ini.getX()) > 10.0) {
            SaveRasterPanel dialog = saveRaster.getControlsPanel();
            dialog.getBProperties().setEnabled(false);
            dialog.setViewPort(vp);
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(Locale.ENGLISH);
            nf.applyPattern("#.#");
            nf.setMaximumFractionDigits(4);
            if (!vp.getProjection().isProjected()) {
                nf.setMaximumFractionDigits(6);
            }
            try {
                dialog.getTInfDerX().setValue(nf.format(this.rect.getMaximum(0)));
            }
            catch (IndexOutOfBoundsException ex) {
                dialog.getTInfDerX().setValue(String.valueOf(this.rect.getMaximum(0)));
            }
            try {
                dialog.getTInfDerY().setValue(nf.format(this.rect.getMinimum(1)));
            }
            catch (IndexOutOfBoundsException ex) {
                dialog.getTInfDerY().setValue(String.valueOf(this.rect.getMinimum(1)));
            }
            try {
                dialog.getTSupIzqX().setValue(nf.format(this.rect.getMinimum(0)));
            }
            catch (IndexOutOfBoundsException ex) {
                dialog.getTSupIzqX().setValue(String.valueOf(this.rect.getMinimum(0)));
            }
            try {
                dialog.getTSupIzqY().setValue(nf.format(this.rect.getMaximum(1)));
            }
            catch (IndexOutOfBoundsException ex) {
                dialog.getTSupIzqY().setValue(String.valueOf(this.rect.getMaximum(1)));
            }
            if (!open) {
                PluginServices.getMDIManager().addWindow((IWindow)saveRaster);
            }
        }
    }

    public Image getImageCursor() {
        return this.isaveraster;
    }
}

