/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.saveviewtoraster.ui.listener;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JOptionPane;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.propertiespanel.PropertiesPanel;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.mainplugin.config.Configuration;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.algorithm.swing.saveraster.SaveRasterPanel;
import org.gvsig.raster.tools.app.basic.tool.saveraster.ui.property.WriterPropertiesDialog;
import org.gvsig.raster.tools.app.basic.tool.saveviewtoraster.ui.SaveViewToRasterDialog;
import org.gvsig.raster.tools.app.basic.tool.saveviewtoraster.ui.listener.SaveRasterActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveViewToRasterDialogListener
implements ButtonsPanelListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private Logger log = LoggerFactory.getLogger(SaveViewToRasterDialogListener.class);
    private SaveViewToRasterDialog dialog = null;
    private FLayers layers = null;
    private MapControl mapCtrl = null;
    private RasterWriter writer = null;

    public SaveViewToRasterDialogListener(SaveViewToRasterDialog dialog, FLayers layers, MapControl mapCtrl) {
        this.dialog = dialog;
        this.layers = layers;
        this.mapCtrl = mapCtrl;
        dialog.addButtonPressedListener(this);
        dialog.getSaveRasterPanel().getBProperties().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveViewToRasterDialogListener.this.propsButtonActionPerformed(evt);
            }
        });
    }

    public boolean isCorrectlyConfigured() {
        SaveRasterPanel controlPanel = this.dialog.getSaveRasterPanel();
        try {
            String fName;
            double ulx = Double.parseDouble(controlPanel.getValueULX());
            double uly = Double.parseDouble(controlPanel.getValueULY());
            double lrx = Double.parseDouble(controlPanel.getValueLRX());
            double lry = Double.parseDouble(controlPanel.getValueLRY());
            if (Math.abs(uly - ulx) == 0.0 || Math.abs(lry - lrx) == 0.0) {
                RasterSwingLibrary.messageBoxError((String)"wc_wrong", (Object)controlPanel);
                return false;
            }
            if (controlPanel.isPixelMethodSelected()) {
                int wpx = Integer.parseInt(controlPanel.getWidthPxValue());
                int hpx = Integer.parseInt(controlPanel.getHeightPxValue());
                double cellsize = Double.parseDouble(controlPanel.getCellSize());
                if (wpx == 0) {
                    RasterSwingLibrary.messageBoxError((String)"width_cannot_be_zero", (Object)controlPanel);
                    return false;
                }
                if (hpx == 0) {
                    RasterSwingLibrary.messageBoxError((String)"height_cannot_be_zero", (Object)controlPanel);
                    return false;
                }
                if (cellsize == 0.0) {
                    RasterSwingLibrary.messageBoxError((String)"cellsize_cannot_be_zero", (Object)controlPanel);
                    return false;
                }
            } else {
                int cmsx = Integer.parseInt(controlPanel.getValueXCms());
                int cmsy = Integer.parseInt(controlPanel.getValueYCms());
                int scale = Integer.parseInt(controlPanel.getScaleValue());
                if (cmsx == 0) {
                    RasterSwingLibrary.messageBoxError((String)"width_cannot_be_zero", (Object)controlPanel);
                    return false;
                }
                if (cmsy == 0) {
                    RasterSwingLibrary.messageBoxError((String)"height_cannot_be_zero", (Object)controlPanel);
                    return false;
                }
                if (scale == 0) {
                    RasterSwingLibrary.messageBoxError((String)"scale_cannot_be_zero", (Object)controlPanel);
                    return false;
                }
            }
            if ((fName = controlPanel.getLFileName().getText()) == null || fName.equals("")) {
                RasterSwingLibrary.messageBoxError((String)"filename_cannot_be_empty", (Object)controlPanel);
                return false;
            }
        }
        catch (NumberFormatException e) {
            RasterSwingLibrary.messageBoxError((String)"some_parameter_is_not_correct", (Object)controlPanel);
            return false;
        }
        return true;
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        switch (e.getButton()) {
            case 3: {
                if (!this.isCorrectlyConfigured()) break;
                this.checkProjections();
                this.acceptButtonActionPerformed(e);
                break;
            }
            case 6: {
                this.dialog.closeJDialog();
            }
        }
    }

    private boolean checkProjections() {
        IProjection viewProj = this.mapCtrl.getProjection();
        for (int i = 0; i < this.layers.getLayersCount(); ++i) {
            FLayer lyr = this.layers.getLayer(i);
            if (lyr.getProjection() != null && lyr.getProjection().getAbrev().equals(viewProj.getAbrev())) continue;
            RasterSwingLibrary.messageBoxInfo((String)"different_projection", (Object)((Object)this.dialog));
            return false;
        }
        return true;
    }

    private boolean acceptButtonActionPerformed(ButtonsPanelEvent e) {
        SaveRasterPanel controlPanel = this.dialog.getSaveRasterPanel();
        String fName = this.dialog.getDataInputListener().getFileName();
        int wpx = 0;
        int hpx = 0;
        if (controlPanel.isPixelMethodSelected()) {
            wpx = Integer.valueOf(controlPanel.getWidthPxValue());
            hpx = Integer.valueOf(controlPanel.getHeightPxValue());
        } else {
            wpx = controlPanel.getWidthPxPrint();
            hpx = controlPanel.getHeightPxPrint();
        }
        Dimension dimension = new Dimension(wpx, hpx);
        if (!(wpx <= 20000 && wpx <= 20000 || RasterSwingLibrary.messageBoxYesOrNot((String)"output_file_too_big", null))) {
            return false;
        }
        File f = new File(fName);
        if (f.exists() && !RasterSwingLibrary.messageBoxYesOrNot((String)"raster_error_file_exists", (Object)((Object)this.dialog))) {
            return false;
        }
        f = new File(fName.substring(0, fName.lastIndexOf(File.separator)));
        if (f.exists() && f.isDirectory() && !f.canWrite()) {
            RasterSwingLibrary.messageBoxError((String)"error_file_not_writable", (Object)((Object)this.dialog));
            return false;
        }
        double lrX = Double.parseDouble(controlPanel.getValueLRX());
        double lrY = Double.parseDouble(controlPanel.getValueLRY());
        double ulX = Double.parseDouble(controlPanel.getValueULX());
        double ulY = Double.parseDouble(controlPanel.getValueULY());
        Envelope ext = null;
        try {
            ext = geomManager.createEnvelope(ulX, lrY, lrX, ulY, 0);
        }
        catch (CreateEnvelopeException e1) {
            this.log.debug("Error creating the envelope", null, (Object)e1);
        }
        long bytes = RasterLocator.getManager().getRasterUtils().getBytesFromRaster((int)dimension.getWidth(), (int)dimension.getHeight(), 0, 3);
        long maxJp2 = 487500000L;
        if (fName.endsWith(".jp2") && bytes > maxJp2 && !RasterSwingLibrary.messageBoxYesOrNot((String)"output_file_too_big_jpeg2000", null)) {
            return false;
        }
        Params params = this.getWriterParams(fName);
        int blockSize = this.getBlockSize(params, this.layers);
        ViewPort viewPort = new ViewPort(this.mapCtrl.getViewPort().getProjection());
        viewPort.setBackColor(this.mapCtrl.getViewPort().getBackColor());
        viewPort.setImageSize(dimension);
        viewPort.setEnvelope(ext);
        try {
            DataProcess saveRasterProcess = RasterBaseAlgorithmLibrary.getManager().createRasterTask("SaveRasterProcess");
            saveRasterProcess.setActions((IProcessActions)new SaveRasterActions(this.dialog.getViewName()));
            saveRasterProcess.addParam("ViewPort", (Object)viewPort);
            saveRasterProcess.addParam("Dimension", (Object)dimension);
            saveRasterProcess.addParam("Blocksize", (Object)blockSize);
            saveRasterProcess.addParam("FileName", (Object)fName);
            saveRasterProcess.addParam("FLyrs", (Object)this.layers);
            saveRasterProcess.addParam("writerparams", (Object)params);
            saveRasterProcess.addParam("Projection", (Object)this.mapCtrl.getProjection());
            saveRasterProcess.start();
        }
        catch (ProcessException e1) {
            RasterSwingLibrary.messageBoxError((String)"error_processing", (Object)this, (Exception)((Object)e1));
        }
        return true;
    }

    private void propsButtonActionPerformed(ActionEvent e) {
        String name = this.dialog.getDataInputListener().getFileName();
        if (name == null || name.equals("")) {
            return;
        }
        Params params = this.getWriterParams(name);
        PropertiesPanel panel = new PropertiesPanel();
        WriterPropertiesDialog dialog = new WriterPropertiesDialog(panel, params);
        PluginServices.getMDIManager().addWindow((IWindow)dialog);
    }

    private Params getWriterParams(String name) {
        RasterManager rManager = RasterLocator.getManager();
        String ext = rManager.getFileUtils().getExtensionFromFileName(name);
        try {
            if (this.writer == null) {
                this.writer = rManager.createWriter(name);
            } else {
                String oldType;
                String newType = rManager.getProviderServices().getWriteDriverType(ext);
                if (!newType.equals(oldType = this.writer.getDriverName())) {
                    this.writer = rManager.createWriter(name);
                }
            }
            if (this.writer == null) {
                JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            }
            return this.writer.getParams();
        }
        catch (NotSupportedExtensionException e1) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            return null;
        }
        catch (RasterDriverException e1) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            return null;
        }
    }

    private int getBlockSize(Params params, FLayers flyrs) {
        int blockSize = Configuration.getValue((String)"cache_blockheight", (Integer)RasterLibrary.blockHeight);
        blockSize = RasterLibrary.blockHeight;
        int[] wBlock = null;
        boolean isTiling = false;
        int block = Integer.MAX_VALUE;
        for (int i = 0; i < flyrs.getLayersCount(); ++i) {
            if (!(flyrs.getLayer(i) instanceof FLyrRaster) || !((FLyrRaster)flyrs.getLayer(i)).isTiled() || (wBlock = ((FLyrRaster)flyrs.getLayer(i)).getTileSize())[0] - 1 >= block) continue;
            block = wBlock[0] - 1;
            isTiling = true;
        }
        if (isTiling) {
            params.changeParamValue("blocksize", (Object)String.valueOf(block));
            return block;
        }
        return blockSize;
    }
}

