/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.viewexport;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import java.awt.Component;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.raster.tools.app.basic.tool.viewexport.MyFileFilter;
import org.gvsig.raster.tools.app.basic.tool.viewexport.RasterizerImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export
extends Extension {
    private Logger log = LoggerFactory.getLogger(Export.class);
    private String lastPath = null;
    private Hashtable<String, MyFileFilter> cmsExtensionsSupported = null;
    private Hashtable<String, MyFileFilter> jimiExtensionsSupported = null;

    public boolean isEnabled() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null || !(f instanceof AbstractViewPanel)) {
            return false;
        }
        AbstractViewPanel avp = (AbstractViewPanel)f;
        FLayers layers = avp.getMapControl().getMapContext().getLayers();
        for (int i = 0; i < layers.getLayersCount(); ++i) {
            if (layers.getLayer(i) == null) continue;
            return layers.getLayer(i).isAvailable();
        }
        return false;
    }

    public boolean isVisible() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        return f instanceof AbstractViewPanel;
    }

    public void initialize() {
    }

    public void postInitialize() {
        this.cmsExtensionsSupported = new Hashtable();
        this.jimiExtensionsSupported = new Hashtable();
        this.cmsExtensionsSupported.put("jpg", new MyFileFilter("jpg", PluginServices.getText((Object)((Object)this), (String)"jpeg_file"), "cms"));
        this.jimiExtensionsSupported.put("png", new MyFileFilter("png", PluginServices.getText((Object)((Object)this), (String)"png_file"), "cms"));
        this.jimiExtensionsSupported.put("bmp", new MyFileFilter("bmp", PluginServices.getText((Object)((Object)this), (String)"bmp_file"), "cms"));
        this.cmsExtensionsSupported.put("tif", new MyFileFilter("tif", PluginServices.getText((Object)((Object)this), (String)"tif_file"), "cms"));
    }

    public static boolean saveImageCMS(File fileDst, BufferedImage srcImage) throws RasterDriverException, IOException {
        RasterManager manager = RasterLocator.getManager();
        RasterizerImage data = new RasterizerImage(srcImage);
        RasterWriter writer = null;
        try {
            Params params = manager.createWriter(fileDst.getAbsolutePath()).getParams();
            params.changeParamValue("blocksize", (Object)"7");
            params.changeParamValue("tfw", (Object)"false");
            params.changeParamValue("interleave", (Object)new Integer(1));
            writer = manager.createWriter((DataServerWriter)data, fileDst.getAbsolutePath(), 3, new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f), srcImage.getWidth(), srcImage.getHeight(), -1, params, null);
            if (writer == null) {
                PluginServices.getLogger().error("No supported Format: " + fileDst.getAbsolutePath());
                return false;
            }
        }
        catch (NotSupportedExtensionException e) {
            throw new RasterDriverException("");
        }
        try {
            writer.dataWrite();
        }
        catch (ProcessInterruptedException processInterruptedException) {
            // empty catch block
        }
        writer.writeClose();
        return true;
    }

    public static boolean saveImageJimi(File fileDst, BufferedImage srcImage) throws Exception {
        try {
            Jimi.putImage((Image)srcImage, (String)fileDst.getAbsolutePath());
        }
        catch (JimiException e) {
            throw new Exception(fileDst.getAbsolutePath(), e);
        }
        return true;
    }

    public void execute(String actionCommand) {
        JFileChooser jfc = new JFileChooser(this.lastPath);
        jfc.removeChoosableFileFilter(jfc.getAcceptAllFileFilter());
        Iterator<MyFileFilter> iter = this.cmsExtensionsSupported.values().iterator();
        while (iter.hasNext()) {
            jfc.addChoosableFileFilter(iter.next());
        }
        iter = this.jimiExtensionsSupported.values().iterator();
        while (iter.hasNext()) {
            jfc.addChoosableFileFilter(iter.next());
        }
        jfc.setFileFilter(this.jimiExtensionsSupported.get("png"));
        if (jfc.showSaveDialog((Component)PluginServices.getMainFrame()) == 0) {
            int resp;
            BufferedImage tempImage = ((AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow()).getImage();
            File f = jfc.getSelectedFile();
            this.lastPath = f.getParent();
            MyFileFilter filter = (MyFileFilter)jfc.getFileFilter();
            f = filter.normalizeExtension(f);
            if (f.exists() && (resp = JOptionPane.showConfirmDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)((Object)this), (String)"fichero_ya_existe_seguro_desea_guardarlo") + "\n" + f.getAbsolutePath(), PluginServices.getText((Object)((Object)this), (String)"guardar"), 0)) != 0) {
                return;
            }
            if (filter.getInfo().equalsIgnoreCase("cms")) {
                try {
                    Export.saveImageCMS(f, tempImage);
                }
                catch (IOException e) {
                    this.log.debug("Error exportando la imagen", (Throwable)e);
                }
                catch (RasterDriverException e) {
                    this.log.debug("Error exportando la imagen", (Throwable)e);
                }
            } else if (filter.getInfo().equalsIgnoreCase("jimi")) {
                try {
                    Export.saveImageJimi(f, tempImage);
                }
                catch (Exception e) {
                    this.log.debug("Error exportando la imagen", (Throwable)e);
                }
            }
        }
    }
}

