/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension;

import java.util.Map;
import org.gvsig.hyperlink.app.extension.AbstractHyperLinkPanel;
import org.gvsig.hyperlink.app.extension.ILinkActionManager;
import org.gvsig.hyperlink.app.extension.LinkTarget;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionManager
implements ILinkActionManager {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractActionManager.class);
    private final String actionCode;
    private final String name;
    private final String description;

    protected AbstractActionManager(String actionCode, String name, String description) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.actionCode = actionCode;
        this.name = i18n.getTranslation(name);
        this.description = i18n.getTranslation(description);
    }

    @Override
    public AbstractHyperLinkPanel createPanel(LinkTarget document) throws UnsupportedOperationException {
        return null;
    }

    @Override
    public String getActionCode() {
        return this.actionCode;
    }

    @Override
    public boolean hasPanel() {
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void showDocument(LinkTarget doc) throws UnsupportedOperationException {
        LOGGER.warn("showDocument not implemented in " + this.getClass().getSimpleName());
    }

    public Object create() {
        return this;
    }

    public Object create(Object[] args) {
        return this;
    }

    public Object create(Map args) {
        return this;
    }
}

