/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension;

import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.hyperlink.app.extension.HyperlinkExtension;
import org.gvsig.hyperlink.app.extension.config.gui.ConfigTab;
import org.gvsig.hyperlink.app.extension.layers.ManagerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkConfigExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(LinkConfigExtension.class);
    ManagerRegistry layerManager;

    public void execute(String s) {
        logger.debug("Command : " + s);
        if (s.compareTo("LINK_SETTINGS") == 0) {
            IView view = (IView)PluginServices.getMDIManager().getActiveWindow();
            HyperlinkExtension ext = (HyperlinkExtension)PluginServices.getExtension(HyperlinkExtension.class);
            ext.initTool(view);
            FLayer[] activas = view.getMapControl().getMapContext().getLayers().getActives();
            for (int i = 0; i < activas.length; ++i) {
                if (!activas[i].isAvailable()) {
                    return;
                }
                if (!this.layerManager.hasManager(activas[i])) continue;
                ConfigTab configWindow = new ConfigTab();
                configWindow.setModel(activas[i]);
                PluginServices.getMDIManager().addCentredWindow((IWindow)configWindow);
            }
        }
    }

    public boolean isVisible() {
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window == null) {
            return false;
        }
        if (window instanceof IView) {
            MapContext mapa = ((IView)window).getViewDocument().getMapContext();
            return mapa.getLayers().getLayersCount() > 0;
        }
        return false;
    }

    public boolean isEnabled() {
        IView view;
        ViewDocument model;
        FLayer[] activas;
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window == null) {
            return false;
        }
        return window instanceof IView && (activas = (model = (view = (IView)window).getViewDocument()).getMapContext().getLayers().getActives()).length == 1 && activas[0].isAvailable() && this.layerManager.hasManager(activas[0]);
    }

    public void postInitialize() {
        HyperlinkExtension ext = (HyperlinkExtension)PluginServices.getExtension(HyperlinkExtension.class);
        this.layerManager = ext.getLayerManager();
    }

    public void initialize() {
    }
}

