/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.alg;

import java.util.List;
import org.javanetworkanalyzer.alg.DFS;
import org.javanetworkanalyzer.data.VStrahler;
import org.javanetworkanalyzer.model.EdgeSPT;
import org.jgrapht.Graph;

public class DFSForStrahler<E extends EdgeSPT>
extends DFS<VStrahler, E> {
    public DFSForStrahler(Graph<VStrahler, E> graph) {
        super(graph);
    }

    @Override
    protected void visit(VStrahler node) {
        super.visit(node);
        this.calculateStrahlerNumber(node);
    }

    private void calculateStrahlerNumber(VStrahler node) {
        if (node.getFinishingTime() == node.getDiscoveryTime() + 1) {
            node.setStrahlerNumber(1);
        } else {
            int outDegree = this.outdegree(node);
            if (outDegree == 1) {
                List<VStrahler> neighborsOf = this.successorListOf(node);
                if (neighborsOf.size() != 1) {
                    throw new IllegalStateException("There should be exactly one child!");
                }
                VStrahler child = neighborsOf.iterator().next();
                node.setStrahlerNumber(child.getStrahlerNumber());
            } else {
                int secondLargest;
                int[] topTwo = this.topTwoStrahlerNumbers(node);
                int max = topTwo[0];
                if (max == (secondLargest = topTwo[1])) {
                    node.setStrahlerNumber(max + 1);
                } else {
                    node.setStrahlerNumber(max);
                }
            }
        }
    }

    private int[] topTwoStrahlerNumbers(VStrahler node) {
        int max = Integer.MIN_VALUE;
        int secondLargest = Integer.MIN_VALUE;
        for (VStrahler child : this.successorListOf(node)) {
            int s = child.getStrahlerNumber();
            if (s > max) {
                secondLargest = max;
                max = s;
                continue;
            }
            if (s <= secondLargest) continue;
            secondLargest = s;
        }
        return new int[]{max, secondLargest};
    }
}

