/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.analyzers;

import java.lang.reflect.InvocationTargetException;
import java.util.Stack;
import org.javanetworkanalyzer.alg.CentralityAlg;
import org.javanetworkanalyzer.analyzers.GeneralizedGraphAnalyzer;
import org.javanetworkanalyzer.data.PathLengthData;
import org.javanetworkanalyzer.data.VCent;
import org.javanetworkanalyzer.model.EdgeCent;
import org.javanetworkanalyzer.model.TraversalGraph;
import org.javanetworkanalyzer.progress.NullProgressMonitor;
import org.javanetworkanalyzer.progress.ProgressMonitor;
import org.jgrapht.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphAnalyzer<V extends VCent, E extends EdgeCent, S extends PathLengthData>
extends GeneralizedGraphAnalyzer<V, E> {
    private double maxBetweenness;
    private double minBetweenness;
    private double maxEdgeBetweenness;
    private double minEdgeBetweenness;
    protected ProgressMonitor pm;
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphAnalyzer.class);
    protected final Stack<V> stack;

    public GraphAnalyzer(Graph<V, E> graph, ProgressMonitor pm) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        super(graph);
        this.pm = pm;
        this.stack = new Stack();
        this.maxBetweenness = Double.NEGATIVE_INFINITY;
        this.minBetweenness = Double.POSITIVE_INFINITY;
        this.maxEdgeBetweenness = Double.NEGATIVE_INFINITY;
        this.minEdgeBetweenness = Double.POSITIVE_INFINITY;
    }

    public GraphAnalyzer(Graph<V, E> graph, Class<? extends S> pathClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this(graph, new NullProgressMonitor());
    }

    public void computeAll() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        long startTime = System.currentTimeMillis();
        long count = 0L;
        this.pm.setProgress(count, startTime);
        for (VCent node : this.nodeSet) {
            ++count;
            if (this.pm.isCancelled()) break;
            this.calculateCentralityContributionFromNode(node);
            this.pm.setProgress(count, startTime);
        }
        this.normalizeBetweenness();
    }

    private void calculateCentralityContributionFromNode(V startNode) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        CentralityAlg<V, E, S> alg = this.calculateShortestPathsFromNode(startNode);
        this.calculateClosenessForNode(startNode, alg.getPaths());
        TraversalGraph sPT = alg.reconstructTraversalGraph();
        this.accumulateDependencies(startNode, sPT);
    }

    protected abstract CentralityAlg<V, E, S> calculateShortestPathsFromNode(V var1);

    protected void calculateClosenessForNode(V node, S paths) {
        int reachableNodes = ((PathLengthData)paths).getCount();
        double avgPathLength = reachableNodes == this.nodeCount - 1 ? ((PathLengthData)paths).getAverageLength() : -1.0;
        double closeness = avgPathLength > 0.0 ? 1.0 / avgPathLength : 0.0;
        node.setCloseness(closeness);
    }

    private void accumulateDependencies(V startNode, TraversalGraph<V, E> shortestPathTree) {
        while (!this.stack.empty()) {
            VCent w = (VCent)this.stack.pop();
            for (VCent predecessor : w.getPredecessors()) {
                double oldDep = predecessor.getDependency();
                double sigmaFactor = (double)predecessor.getSPCount() / (double)w.getSPCount();
                double depContribution = sigmaFactor * (1.0 + w.getDependency());
                predecessor.accumulateDependency(depContribution);
                this.accumEdgeBetw(predecessor, w, sigmaFactor, shortestPathTree);
            }
            if (w == startNode) continue;
            double oldBetw = w.getBetweenness();
            w.accumulateBetweenness(w.getDependency());
        }
    }

    private void accumEdgeBetw(V predecessor, V w, double sigmaFactor, TraversalGraph<V, E> shortestPathTree) {
        for (EdgeCent sPTEdge : shortestPathTree.getAllEdges(predecessor, w)) {
            double depSumFromOutgoing = 0.0;
            for (EdgeCent outEdge : shortestPathTree.outgoingEdgesOf(w)) {
                depSumFromOutgoing += outEdge.getDependency();
            }
            sPTEdge.accumulateDependency(sigmaFactor * (1.0 + depSumFromOutgoing));
            ((EdgeCent)sPTEdge.getBaseGraphEdge()).accumulateBetweenness(sPTEdge.getDependency());
        }
    }

    private void normalizeBetweenness() {
        long start = System.currentTimeMillis();
        this.findExtremeBetweennessValues();
        double vertexBetwRange = this.maxBetweenness - this.minBetweenness;
        if (vertexBetwRange == 0.0) {
            LOGGER.warn("All vertex betweenness values are zero.");
        } else {
            for (VCent node : this.nodeSet) {
                double normalizedBetweenness = (node.getBetweenness() - this.minBetweenness) / vertexBetwRange;
                node.setBetweenness(normalizedBetweenness);
            }
        }
        double edgeBetwRange = this.maxEdgeBetweenness - this.minEdgeBetweenness;
        if (edgeBetwRange == 0.0) {
            LOGGER.warn("All edge betweenness values are zero.");
        } else {
            for (EdgeCent edge : this.graph.edgeSet()) {
                double normalizedBetweenness = (edge.getBetweenness() - this.minEdgeBetweenness) / edgeBetwRange;
                edge.setBetweenness(normalizedBetweenness);
            }
        }
        long stop = System.currentTimeMillis();
        LOGGER.info("({} ms) Betweenness normalization.", (Object)(stop - start));
    }

    private void findExtremeBetweennessValues() {
        double betweenness;
        long start = System.currentTimeMillis();
        for (VCent node : this.nodeSet) {
            betweenness = node.getBetweenness();
            if (betweenness > this.maxBetweenness) {
                this.maxBetweenness = betweenness;
            }
            if (!(betweenness < this.minBetweenness)) continue;
            this.minBetweenness = betweenness;
        }
        for (EdgeCent edge : this.graph.edgeSet()) {
            betweenness = edge.getBetweenness();
            if (betweenness > this.maxEdgeBetweenness) {
                this.maxEdgeBetweenness = betweenness;
            }
            if (!(betweenness < this.minEdgeBetweenness)) continue;
            this.minEdgeBetweenness = betweenness;
        }
        long stop = System.currentTimeMillis();
        LOGGER.info("({} ms) Extreme betweenness values v({}, {}), e({}, {}).", new Object[]{stop - start, this.minBetweenness, this.maxBetweenness, this.minEdgeBetweenness, this.maxEdgeBetweenness});
    }
}

